/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.play.util.configuration.Config;
import ru.quadcom.play.util.configuration.ConfigurationItemHolder;
import ru.quadcom.play.util.configuration.parsers.IConfigurationValueParser;
import ru.quadcom.play.util.configuration.parsers.Parsers;

public class ConfigurationInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationInvocationHandler.class);
    private final ConfigurationItemHolder itemHolder;
    private Map<Method, String> itemNameByMethod;

    ConfigurationInvocationHandler(ConfigurationItemHolder itemHolder, Class configurationClass) {
        this.itemHolder = itemHolder;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(configurationClass);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            this.itemNameByMethod = new HashMap<Method, String>();
            for (PropertyDescriptor pd : propertyDescriptors) {
                this.itemNameByMethod.put(pd.getReadMethod(), pd.getName());
            }
        }
        catch (IntrospectionException e) {
            logger.warn("Failed to get introspection info for class " + configurationClass.getName(), (Throwable)e);
            this.itemNameByMethod = Collections.emptyMap();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Properties properties = this.itemHolder.parseValue(Parsers.PROPERTIES_PARSER, Parsers.EMPTY_PROPERTIES);
        String itemName = this.itemNameByMethod.get(method);
        if (itemName == null) {
            itemName = method.getName();
        }
        Config config = method.getAnnotation(Config.class);
        String rawItemValue = properties.getProperty(itemName);
        if (rawItemValue == null && config != null) {
            rawItemValue = config.defaultValue();
        }
        if (config != null && !config.parser().equals(IConfigurationValueParser.class)) {
            IConfigurationValueParser configurationValueParser = config.parser().newInstance();
            return configurationValueParser.parseValue(rawItemValue, null);
        }
        if (method.getReturnType().isPrimitive()) {
            return this.parsePrimitive(method.getReturnType(), rawItemValue);
        }
        return this.parseByReturnType(method, rawItemValue);
    }

    private Object parsePrimitive(Class<?> returnType, String rawItemValue) {
        if (Integer.TYPE.equals(returnType)) {
            try {
                return Integer.parseInt(rawItemValue);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unable to parse int value from " + rawItemValue);
            }
        }
        if (Long.TYPE.equals(returnType)) {
            try {
                return Long.parseLong(rawItemValue);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unable to parse long value from " + rawItemValue);
            }
        }
        if (Double.TYPE.equals(returnType)) {
            try {
                return Double.parseDouble(rawItemValue);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unable to parse double value from " + rawItemValue);
            }
        }
        if (Float.TYPE.equals(returnType)) {
            try {
                return Float.valueOf(Float.parseFloat(rawItemValue));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unable to parse float value from " + rawItemValue);
            }
        }
        if (Short.TYPE.equals(returnType)) {
            try {
                return Float.valueOf(Float.parseFloat(rawItemValue));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Unable to parse float value from " + rawItemValue);
            }
        }
        if (Character.TYPE.equals(returnType)) {
            if (rawItemValue != null && !rawItemValue.isEmpty()) {
                return Character.valueOf(rawItemValue.charAt(0));
            }
            throw new IllegalStateException("Unexpected string to get char from \"" + rawItemValue + "\"");
        }
        if (Boolean.TYPE.equals(returnType)) {
            return Boolean.valueOf(rawItemValue);
        }
        throw new IllegalStateException("Unexpected return type " + returnType.getName());
    }

    private Object parseByReturnType(Method method, String rawItemValue) {
        if (List.class.isAssignableFrom(method.getReturnType())) {
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                Type parameter = parameterizedType.getActualTypeArguments()[0];
                if (String.class.equals((Object)parameter)) {
                    return Parsers.LIST_STRING_PARSER.parseValue(rawItemValue, null);
                }
                if (Long.class.equals((Object)parameter)) {
                    return Parsers.LIST_LONG_PARSER.parseValue(rawItemValue, null);
                }
                if (Integer.class.equals((Object)parameter)) {
                    return Parsers.LIST_INTEGER_PARSER.parseValue(rawItemValue, null);
                }
                throw new IllegalStateException("Unexpected type of List parameter " + parameter);
            }
            return Parsers.LIST_STRING_PARSER.parseValue(rawItemValue, null);
        }
        if (Set.class.isAssignableFrom(method.getReturnType())) {
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                Type parameter = parameterizedType.getActualTypeArguments()[0];
                if (String.class.equals((Object)parameter)) {
                    return Parsers.SET_STRING_PARSER.parseValue(rawItemValue, null);
                }
                if (Long.class.equals((Object)parameter)) {
                    return Parsers.SET_LONG_PARSER.parseValue(rawItemValue, null);
                }
                if (Integer.class.equals((Object)parameter)) {
                    return Parsers.SET_INTEGER_PARSER.parseValue(rawItemValue, null);
                }
                throw new IllegalStateException("Unexpected type of Set parameter " + parameter);
            }
            return Parsers.SET_STRING_PARSER.parseValue(rawItemValue, null);
        }
        if (String.class.equals(method.getReturnType())) {
            return Parsers.STRING_PARSER.parseValue(rawItemValue, null);
        }
        if (Long.class.equals(method.getReturnType())) {
            return Parsers.LONG_PARSER.parseValue(rawItemValue, null);
        }
        if (Integer.class.equals(method.getReturnType())) {
            return Parsers.INTEGER_PARSER.parseValue(rawItemValue, null);
        }
        throw new IllegalStateException("Unexpected return type " + method.getReturnType().getName());
    }
}

