/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.actions;

import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.commons.exceptions.UnauthorizedException;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.service.to.service.ServicesSecrets;
import ru.quadcom.play.util.RequestHelper;
import ru.quadcom.play.util.actions.AuthorizeServiceToService;

public class AuthorizeServiceToServiceAction
extends Action<AuthorizeServiceToService> {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeServiceToServiceAction.class);
    private static final String X_SERVICE_ACCESS_TOKEN = "X-Service-Access-Token";

    public CompletionStage<Result> call(Http.Context ctx) {
        String serviceName = ((AuthorizeServiceToService)this.configuration).serviceName();
        String tokenString = AuthorizeServiceToServiceAction.parseTokenString(ctx.request());
        ServiceToServiceToken token = AuthorizeServiceToServiceAction.authorize(tokenString, serviceName);
        ctx.args.put("service_token", token);
        return this.delegate.call(ctx);
    }

    private static String parseTokenString(Http.Request request) {
        return RequestHelper.parseHeader(X_SERVICE_ACCESS_TOKEN, request);
    }

    private static ServiceToServiceToken authorize(String accessToken, String serviceName) {
        if (accessToken == null) {
            throw new MissingParameterException("Missing service access token", null);
        }
        ServicesSecrets servicesSecrets = ServicesSecrets.valueOf((String)serviceName);
        ServiceToServiceToken token = ServiceToServiceToken.decode((String)accessToken, (ServicesSecrets)servicesSecrets);
        if (token.isExpired()) {
            throw new UnauthorizedException();
        }
        return token;
    }
}

