/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.actions;

import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.commons.exceptions.UnauthorizedException;
import ru.quadcom.commons.identity.Token;
import ru.quadcom.play.util.RequestHelper;
import ru.quadcom.play.util.actions.Authorize;

public class AuthorizeAction
extends Action<Authorize> {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeAction.class);
    private static final String ACCESS_TOKEN_HEADER = "X-Access-Token";

    public CompletionStage<Result> call(Http.Context ctx) {
        String scope = ((Authorize)this.configuration).scope();
        String tokenString = AuthorizeAction.parseTokenString(ctx.request());
        Token token = AuthorizeAction.authorize(tokenString);
        ctx.args.put("token", token);
        return this.delegate.call(ctx);
    }

    private static String parseTokenString(Http.Request request) {
        String tokenString = RequestHelper.parseHeader(ACCESS_TOKEN_HEADER, request);
        if (tokenString == null && "GET".equalsIgnoreCase(request.method())) {
            String[] params = (String[])request.queryString().get("access_token");
            tokenString = params != null && params.length > 0 ? params[0] : null;
        }
        return tokenString;
    }

    private static Token authorize(String accessToken) {
        if (accessToken == null) {
            throw new MissingParameterException("Missing access token", null);
        }
        Token token = Token.decode((String)accessToken);
        if (token.isExpired()) {
            throw new UnauthorizedException();
        }
        return token;
    }
}

