/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Akka;
import play.libs.F;
import play.libs.Json;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;
import ru.quadcom.play.util.configuration.ConfigurationCache;
import ru.quadcom.play.util.configuration.ConfigurationInvocationHandler;
import ru.quadcom.play.util.configuration.ConfigurationItemHolder;
import ru.quadcom.play.util.configuration.ConfigurationUpdater;
import ru.quadcom.play.util.model.configuration.Configuration;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUpdater.class);

    public ConfigurationItemHolder getConfigurationItem(@NotNull String itemName) {
        return new ConfigurationItemHolder(itemName, ConfigurationCache.INSTANCE);
    }

    public <C> C getConfigurationInterface(@NotNull String name, @NotNull Class<? extends C> configurationInterface) {
        ConfigurationInvocationHandler handler = new ConfigurationInvocationHandler(this.getConfigurationItem(name), configurationInterface);
        return (C)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{configurationInterface}, (InvocationHandler)handler);
    }

    public void scheduleConfigRefreshThread(long delayMs, long frequencyMs, String configServiceUpdateUrl, String application, String environment) {
        FiniteDuration delay = FiniteDuration.create((long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS);
        FiniteDuration interval = FiniteDuration.create((long)frequencyMs, (TimeUnit)TimeUnit.MILLISECONDS);
        ConfigurationUpdater updater = new ConfigurationUpdater(configServiceUpdateUrl, application, environment);
        Akka.system().scheduler().schedule(delay, interval, (Runnable)updater, (ExecutionContext)Akka.system().dispatcher());
    }

    public void initConfiguration(String configServiceUrl, String application, String environment, boolean exitOnFailure) {
        block2: {
            F.Promise wsPromise = WS.url((String)configServiceUrl).setQueryParameter("app_name", application).setQueryParameter("env_name", environment).get();
            try {
                F.Function<WSResponse, Configuration> configurationF = new F.Function<WSResponse, Configuration>(){

                    public Configuration apply(WSResponse wsResponse) throws Throwable {
                        if (wsResponse.getStatus() == 200) {
                            return (Configuration)Json.fromJson((JsonNode)wsResponse.asJson(), Configuration.class);
                        }
                        throw new IllegalStateException("Unexpected response status on getting configuration " + wsResponse.getStatus());
                    }
                };
                Configuration result = (Configuration)Await.result((Awaitable)wsPromise.map((F.Function)configurationF).wrapped(), (Duration)Duration.Inf());
                ConfigurationCache.INSTANCE.applyConfiguration(result);
            }
            catch (Exception e) {
                logger.error("Unexpected error on getting the configuration", (Throwable)e);
                if (!exitOnFailure) break block2;
                System.exit(1);
            }
        }
    }
}

