/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration;

import org.apache.commons.lang3.StringUtils;
import ru.quadcom.play.util.configuration.ConfigurationCache;
import ru.quadcom.play.util.configuration.parsers.IConfigurationValueParser;
import ru.quadcom.play.util.configuration.parsers.Parsers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationItemHolder {
    private final String name;
    private final ConfigurationCache configurationCache;

    ConfigurationItemHolder(String name, ConfigurationCache configurationCache) {
        this.name = name;
        this.configurationCache = configurationCache;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.configurationCache.getValue(this.name);
    }

    public Integer getValueAsInteger() {
        return this.parseValue(Parsers.INTEGER_PARSER, null);
    }

    public int getValueAsInt(int defaultValue) {
        String value = this.getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Long getValueAsLong() {
        return this.parseValue(Parsers.LONG_PARSER, null);
    }

    public long getValueAsLong(long defaultValue) {
        String value = this.getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Boolean getValueAsBoolean() {
        String value = this.getValue();
        return StringUtils.isEmpty((CharSequence)value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        String value = this.getValue();
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public <R> R parseValue(IConfigurationValueParser<R> parser, R defaultValue) {
        String value = this.getValue();
        return parser.parseValue(value, defaultValue);
    }
}

