/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.quadcom.play.util.model.configuration.Configuration;
import ru.quadcom.play.util.model.configuration.ConfigurationItem;

public class ConfigurationCache {
    static final ConfigurationCache INSTANCE = new ConfigurationCache();
    private Map<String, String> cachedItems = new ConcurrentHashMap<String, String>(128);
    private volatile long lastUpdate = 0L;

    private ConfigurationCache() {
    }

    void applyConfiguration(Configuration configuration) {
        if (configuration.getItems() != null && !configuration.getItems().isEmpty()) {
            for (ConfigurationItem configurationItem : configuration.getItems()) {
                this.cachedItems.put(configurationItem.getName(), configurationItem.getValue());
            }
            this.lastUpdate = configuration.getLastUpdate();
        }
    }

    String getValue(String name) {
        return this.cachedItems.get(name);
    }

    long getLastUpdate() {
        return this.lastUpdate;
    }
}

