/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.recover;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.PlayException;
import play.mvc.Result;
import play.mvc.Results;
import ru.quadcom.commons.exceptions.ServiceException;

public class DefaultExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    private DefaultExceptionHandler() {
    }

    public static Result handle(Throwable t) {
        if (t == null) {
            return Results.internalServerError();
        }
        if (t instanceof PlayException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)t;
            int errorCode = serviceException.getDefaultHttpStatusCode();
            String accountId = serviceException.getAccountId();
            return Results.status((int)errorCode);
        }
        return Results.internalServerError();
    }
}

