/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.format.ISODateTimeFormat;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.commons.exceptions.TimeSyncException;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.Token;
import ru.quadcom.play.util.RequestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseController
extends Controller {
    public static final String TOKEN = "token";
    public static final String SERVICE_TOKEN = "service_token";
    public static final String LOCALE = "locale";
    public static final String APPLICATION_NAME_HEADER = "X-Application-Name";
    public static final String REQUEST_SENT_TIME = "X-Request-Sent-Time";
    public static final String REQUEST_BODY = "requestBody";
    private static final int CLIENT_SERVER_TIME_DIFF = 3;

    public static void storeRequestBody(Map<String, String[]> reqBody) {
        Http.Context context = BaseController.ctx();
        context.args.put(REQUEST_BODY, reqBody);
    }

    public static Map<String, String[]> getRequestBody() {
        Map reqBody = null;
        if (BaseController.ctx().args.containsKey(REQUEST_BODY)) {
            reqBody = (Map)BaseController.ctx().args.get(REQUEST_BODY);
        }
        return reqBody;
    }

    private static Map<String, String[]> getRequestParameters(Http.Request request) {
        Map params;
        if ("GET".equals(request.method())) {
            params = request.queryString();
        } else {
            params = BaseController.getRequestBody();
            if (params == null || params.isEmpty()) {
                params = request.body().asFormUrlEncoded();
                BaseController.storeRequestBody(params);
                if (params == null) {
                    throw new MissingParameterException("Missing request content type");
                }
            }
        }
        return params;
    }

    public static String getApplicationName() {
        return RequestHelper.parseHeader(APPLICATION_NAME_HEADER, BaseController.request());
    }

    public static DateTime getSendTime() {
        DateTime clientTime = ISODateTimeFormat.dateTime().parseDateTime((String)Json.fromJson((JsonNode)Json.parse((String)RequestHelper.parseHeader(REQUEST_SENT_TIME, BaseController.request())), String.class));
        if (Seconds.secondsBetween((ReadableInstant)clientTime, (ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC)).getSeconds() > 3) {
            throw new TimeSyncException();
        }
        return clientTime;
    }

    public static String getRequiredParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            if (params[0].isEmpty()) {
                throw new MissingParameterException("Missing parameter " + paramName, null);
            }
            return params[0];
        }
        throw new MissingParameterException("Missing parameter " + paramName, null);
    }

    public static String getParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            if (params[0].isEmpty()) {
                return null;
            }
            return params[0];
        }
        return null;
    }

    public static Token getToken() {
        Token token = null;
        if (BaseController.ctx().args.containsKey(TOKEN)) {
            token = (Token)BaseController.ctx().args.get(TOKEN);
        }
        return token;
    }

    public static ServiceToServiceToken getServiceToken() {
        ServiceToServiceToken token = null;
        if (BaseController.ctx().args.containsKey(SERVICE_TOKEN)) {
            token = (ServiceToServiceToken)BaseController.ctx().args.get(SERVICE_TOKEN);
        }
        return token;
    }

    public static String getLocale() {
        String locale = null;
        if (BaseController.ctx().args.containsKey(LOCALE)) {
            locale = (String)BaseController.ctx().args.get(LOCALE);
        }
        return locale;
    }
}

