/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ru.quadcom.play.util.configuration.parsers.IConfigurationValueParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListParser<V>
implements IConfigurationValueParser<List<V>> {
    private final String delimiter;
    private final IConfigurationValueParser<V> itemParser;
    private final V defaultItemValue;
    private final boolean allowNulls;

    ListParser(String delimiter, IConfigurationValueParser<V> itemParser, V defaultItemValue, boolean allowNulls) {
        this.delimiter = delimiter;
        this.itemParser = itemParser;
        this.defaultItemValue = defaultItemValue;
        this.allowNulls = allowNulls;
    }

    @Override
    public List<V> parseValue(String value, List<V> defaultValue) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        String[] split = value.split(this.delimiter);
        if (split == null || split.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<V> result = new ArrayList<V>(split.length);
        for (String item : split) {
            V itemValue = this.itemParser.parseValue(item, this.defaultItemValue);
            if (!this.allowNulls && itemValue == null) continue;
            result.add(itemValue);
        }
        return result;
    }
}

