/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.F;
import play.libs.Json;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;
import ru.quadcom.play.util.configuration.ConfigurationCache;
import ru.quadcom.play.util.model.configuration.Configuration;

public class ConfigurationUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUpdater.class);
    private final String configServiceUrl;
    private final String application;
    private final String environment;

    ConfigurationUpdater(String configServiceUrl, String application, String environment) {
        this.configServiceUrl = configServiceUrl;
        this.application = application;
        this.environment = environment;
    }

    public void run() {
        final long lastUpdate = ConfigurationCache.INSTANCE.getLastUpdate();
        F.Promise wsPromise = WS.url((String)this.configServiceUrl).setQueryParameter("since", String.valueOf(lastUpdate)).setQueryParameter("app_name", this.application).setQueryParameter("env_name", this.environment).get();
        wsPromise.onFailure((F.Callback)new F.Callback<Throwable>(){

            public void invoke(Throwable throwable) throws Throwable {
                logger.error("Unexpected error on configuration update", throwable);
            }
        });
        wsPromise.onRedeem((F.Callback)new F.Callback<WSResponse>(){

            public void invoke(WSResponse wsResponse) throws Throwable {
                if (wsResponse.getStatus() == 200) {
                    Configuration configuration = (Configuration)Json.fromJson((JsonNode)wsResponse.asJson(), Configuration.class);
                    if (configuration != null && configuration.getLastUpdate() > lastUpdate) {
                        ConfigurationCache.INSTANCE.applyConfiguration(configuration);
                    } else {
                        logger.info("Nothing to update from configuration : {} regarding previous update date : {}", (Object)configuration, (Object)lastUpdate);
                    }
                } else {
                    logger.warn("Unexpected status code : {} of response to configuration update request", (Object)wsResponse.getStatus());
                }
            }
        });
    }
}

