/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.actions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.SimpleResult;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.commons.exceptions.UnauthorizedException;
import ru.quadcom.commons.identity.Token;
import ru.quadcom.play.util.RequestHelper;
import ru.quadcom.play.util.actions.Authorize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeAction
extends Action<Authorize> {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizeAction.class);
    private static final String ACCESS_TOKEN_HEADER = "X-Access-Token";

    public F.Promise<SimpleResult> call(Http.Context ctx) throws Throwable {
        String scope = ((Authorize)this.configuration).scope();
        String tokenString = AuthorizeAction.parseTokenString(ctx.request());
        Token token = AuthorizeAction.authorize(tokenString);
        ctx.args.put("token", token);
        return this.delegate.call(ctx);
    }

    private static String parseTokenString(Http.Request request) {
        return RequestHelper.parseHeader(ACCESS_TOKEN_HEADER, request);
    }

    private static Token authorize(String accessToken) {
        if (accessToken == null) {
            throw new MissingParameterException("Missing access token", null);
        }
        Token token = Token.decode((String)accessToken);
        if (token.isExpired()) {
            throw new UnauthorizedException();
        }
        return token;
    }
}

