/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.controllers;

import java.util.Map;
import play.mvc.Controller;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseController
extends Controller {
    public static final String REQUEST_BODY = "requestBody";

    public static void storeRequestBody(Map<String, String[]> reqBody) {
        Http.Context context = BaseController.ctx();
        context.args.put(REQUEST_BODY, reqBody);
    }

    public static Map<String, String[]> getRequestBody() {
        Map reqBody = null;
        if (BaseController.ctx().args.containsKey(REQUEST_BODY)) {
            reqBody = (Map)BaseController.ctx().args.get(REQUEST_BODY);
        }
        return reqBody;
    }

    private static Map<String, String[]> getRequestParameters(Http.Request request) {
        Map params;
        if ("GET".equals(request.method())) {
            params = request.queryString();
        } else {
            params = BaseController.getRequestBody();
            if (params == null || params.isEmpty()) {
                params = request.body().asFormUrlEncoded();
                BaseController.storeRequestBody(params);
                if (params == null) {
                    throw new RuntimeException("Missing request content type");
                }
            }
        }
        return params;
    }

    public static String getParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            return params[0];
        }
        return null;
    }
}

