/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.manage.impl;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.util.Tables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.dynamo.db.lib.annotation.DynamoEntity;
import ru.quadcom.dynamo.db.lib.exceptions.DynamoLibRuntimeException;
import ru.quadcom.dynamo.db.lib.manage.AppDynamoDBClient;
import ru.quadcom.dynamo.db.lib.manage.interfaces.IDynamoTableInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoTableInitializer
implements IDynamoTableInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DynamoTableInitializer.class);
    private final AppDynamoDBClient dbClient;
    private final Map<String, Map<String, Long>> currentTablePropertieMap;
    private final Map<String, String> tableNameToRangeKeyNameMap;

    @Inject
    public DynamoTableInitializer(AppDynamoDBClient appDynamoDBClient) {
        this.dbClient = appDynamoDBClient;
        this.tableNameToRangeKeyNameMap = new HashMap<String, String>();
        this.currentTablePropertieMap = this.listTablesWithProperties();
    }

    @Override
    public <T> long getInitialReadCap(Class<T> clazz) {
        return clazz.getAnnotation(DynamoEntity.class).initialReadCap();
    }

    @Override
    public <T> long getInitialWriteCap(Class<T> clazz) {
        return clazz.getAnnotation(DynamoEntity.class).initialWriteCap();
    }

    @Override
    public <T> void addEntityClass(Class<T> clazz) {
        logger.info("Add dynamo entity class : " + clazz.getName());
        if (clazz.getAnnotation(DynamoEntity.class) == null) {
            throw new DynamoLibRuntimeException(clazz.getName() + " is not the DynamoEntity");
        }
        DynamoEntity dbEntity = clazz.getAnnotation(DynamoEntity.class);
        String tableName = dbEntity.tableName();
        String rangeKeyName = dbEntity.rangeKeyName();
        this.tableNameToRangeKeyNameMap.put(tableName, rangeKeyName);
        String rangeKeyType = dbEntity.rangeKeyType();
        long initialReadCap = dbEntity.initialReadCap();
        long initialWriteCap = dbEntity.initialWriteCap();
        String finalTableName = tableName.concat("-").concat(this.dbClient.getNameOfDatabase());
        if (this.currentTablePropertieMap.get(finalTableName) != null) {
            long oldReadCap = this.currentTablePropertieMap.get(finalTableName).get("READ_CAP_NAME");
            long oldWriteCap = this.currentTablePropertieMap.get(finalTableName).get("WRITE_CAP_NAME");
        } else {
            logger.info("Creating table with finalTableName : " + finalTableName);
            this.createTable(finalTableName, rangeKeyName, rangeKeyType, dbEntity.localSecondaryIndex_1(), dbEntity.localSecondaryIndexType_1(), dbEntity.localSecondaryIndex_2(), dbEntity.localSecondaryIndexType_2(), dbEntity.localSecondaryIndex_3(), dbEntity.localSecondaryIndexType_3(), dbEntity.localSecondaryIndex_4(), dbEntity.localSecondaryIndexType_4(), dbEntity.localSecondaryIndex_5(), dbEntity.localSecondaryIndexType_5(), initialReadCap, initialWriteCap, dbEntity.globalSecondaryIndexName_1(), dbEntity.globalSecondaryIndexHashKey_1(), dbEntity.globalSecondaryIndexHashType_1(), dbEntity.globalSecondaryIndexRangeKey_1(), dbEntity.globalSecondaryIndexRangeType_1(), dbEntity.globalSecondaryIndexInitialReadCap_1(), dbEntity.globalSecondaryIndexInitialWriteCap_1(), dbEntity.globalSecondaryIndexName_2(), dbEntity.globalSecondaryIndexHashKey_2(), dbEntity.globalSecondaryIndexHashType_2(), dbEntity.globalSecondaryIndexRangeKey_2(), dbEntity.globalSecondaryIndexRangeType_2(), dbEntity.globalSecondaryIndexInitialReadCap_2(), dbEntity.globalSecondaryIndexInitialWriteCap_2(), dbEntity.globalSecondaryIndexName_3(), dbEntity.globalSecondaryIndexHashKey_3(), dbEntity.globalSecondaryIndexHashType_3(), dbEntity.globalSecondaryIndexRangeKey_3(), dbEntity.globalSecondaryIndexRangeType_3(), dbEntity.globalSecondaryIndexInitialReadCap_3(), dbEntity.globalSecondaryIndexInitialWriteCap_3(), dbEntity.globalSecondaryIndexName_4(), dbEntity.globalSecondaryIndexHashKey_4(), dbEntity.globalSecondaryIndexHashType_4(), dbEntity.globalSecondaryIndexRangeKey_4(), dbEntity.globalSecondaryIndexRangeType_4(), dbEntity.globalSecondaryIndexInitialReadCap_4(), dbEntity.globalSecondaryIndexInitialWriteCap_4(), dbEntity.globalSecondaryIndexName_5(), dbEntity.globalSecondaryIndexHashKey_5(), dbEntity.globalSecondaryIndexHashType_5(), dbEntity.globalSecondaryIndexRangeKey_5(), dbEntity.globalSecondaryIndexRangeType_5(), dbEntity.globalSecondaryIndexInitialReadCap_5(), dbEntity.globalSecondaryIndexInitialWriteCap_5());
        }
    }

    @Override
    public <T> String getTableName(Class<T> clazz) {
        if (clazz.getAnnotation(DynamoEntity.class) == null) {
            throw new DynamoLibRuntimeException(clazz.getName() + " is not the dynamo entity");
        }
        return clazz.getAnnotation(DynamoEntity.class).tableName();
    }

    private GlobalSecondaryIndex createGlobalSecondaryIndex(String gsiName, String gsiHashKeyName, String gsiHashKeyType, String gsiRangeKeyName, String gsiRangeKeyType, Long gsiReadCap, Long gsiWriteCap, List<AttributeDefinition> attributeDefinitionList) {
        AttributeDefinition gsiHashIndexDefinition;
        if (gsiName.equals("WITHOUT_SECONDARY_INDEX") || gsiHashKeyName.equals("WITHOUT_SECONDARY_INDEX")) {
            return null;
        }
        ScalarAttributeType gsiHashIndexType = ScalarAttributeType.S;
        if (gsiHashKeyType.equals("SECONDARY_INDEX_TYPE_NUMBER")) {
            gsiHashIndexType = ScalarAttributeType.N;
        }
        if (!attributeDefinitionList.contains(gsiHashIndexDefinition = new AttributeDefinition().withAttributeName(gsiHashKeyName).withAttributeType(gsiHashIndexType))) {
            attributeDefinitionList.add(gsiHashIndexDefinition);
        }
        GlobalSecondaryIndex gsi = new GlobalSecondaryIndex().withIndexName(gsiName).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(gsiReadCap).withWriteCapacityUnits(gsiWriteCap)).withProjection(new Projection().withProjectionType("ALL"));
        ArrayList<KeySchemaElement> indexKeySchema = new ArrayList<KeySchemaElement>();
        indexKeySchema.add(new KeySchemaElement().withAttributeName(gsiHashKeyName).withKeyType(KeyType.HASH));
        if (!gsiRangeKeyName.equals("WITHOUT_SECONDARY_INDEX")) {
            AttributeDefinition gsiRangeIndexDefinition;
            ScalarAttributeType gsiRangeIndexType = ScalarAttributeType.S;
            if (gsiRangeKeyType.equals("SECONDARY_INDEX_TYPE_NUMBER")) {
                gsiRangeIndexType = ScalarAttributeType.N;
            }
            if (!attributeDefinitionList.contains(gsiRangeIndexDefinition = new AttributeDefinition().withAttributeName(gsiRangeKeyName).withAttributeType(gsiRangeIndexType))) {
                attributeDefinitionList.add(gsiRangeIndexDefinition);
            }
            indexKeySchema.add(new KeySchemaElement().withAttributeName(gsiRangeKeyName).withKeyType(KeyType.RANGE));
        }
        gsi.setKeySchema(indexKeySchema);
        return gsi;
    }

    private void createLocalSecondaryIndex(String localSecondaryIndexName, String localSecondaryIndexType, KeySchemaElement keySchemaElement, List<AttributeDefinition> attributeDefinitionList, List<LocalSecondaryIndex> localSecondaryIndexes) {
        if (!localSecondaryIndexName.equals("WITHOUT_SECONDARY_INDEX")) {
            AttributeDefinition localIndexDefinition;
            ScalarAttributeType indexType = ScalarAttributeType.S;
            if (localSecondaryIndexType.equals("SECONDARY_INDEX_TYPE_NUMBER")) {
                indexType = ScalarAttributeType.N;
            }
            if (!attributeDefinitionList.contains(localIndexDefinition = new AttributeDefinition().withAttributeName(localSecondaryIndexName).withAttributeType(indexType))) {
                attributeDefinitionList.add(localIndexDefinition);
            }
            ArrayList<KeySchemaElement> indexKeySchema = new ArrayList<KeySchemaElement>();
            indexKeySchema.add(keySchemaElement);
            KeySchemaElement localIndex = new KeySchemaElement().withAttributeName(localSecondaryIndexName).withKeyType(KeyType.RANGE);
            indexKeySchema.add(localIndex);
            Projection projection = new Projection().withProjectionType(ProjectionType.ALL);
            LocalSecondaryIndex localSecondaryIndex = new LocalSecondaryIndex().withIndexName(localSecondaryIndexName).withKeySchema(indexKeySchema).withProjection(projection);
            localSecondaryIndexes.add(localSecondaryIndex);
        }
    }

    private void createTable(String finalTableName, String rangeKeyName, String rangeKeyType, String localSecondaryIndexName_1, String localSecondaryIndexType_1, String localSecondaryIndexName_2, String localSecondaryIndexType_2, String localSecondaryIndexName_3, String localSecondaryIndexType_3, String localSecondaryIndexName_4, String localSecondaryIndexType_4, String localSecondaryIndexName_5, String localSecondaryIndexType_5, long readCap, long writeCap, String globalSecondaryIndexName_1, String globalSecondaryIndexHashKey_1, String globalSecondaryIndexHashType_1, String globalSecondaryIndexRangeKey_1, String globalSecondaryIndexRangeType_1, long globalSecondaryIndexInitialReadCap_1, long globalSecondaryIndexInitialWriteCap_1, String globalSecondaryIndexName_2, String globalSecondaryIndexHashKey_2, String globalSecondaryIndexHashType_2, String globalSecondaryIndexRangeKey_2, String globalSecondaryIndexRangeType_2, long globalSecondaryIndexInitialReadCap_2, long globalSecondaryIndexInitialWriteCap_2, String globalSecondaryIndexName_3, String globalSecondaryIndexHashKey_3, String globalSecondaryIndexHashType_3, String globalSecondaryIndexRangeKey_3, String globalSecondaryIndexRangeType_3, long globalSecondaryIndexInitialReadCap_3, long globalSecondaryIndexInitialWriteCap_3, String globalSecondaryIndexName_4, String globalSecondaryIndexHashKey_4, String globalSecondaryIndexHashType_4, String globalSecondaryIndexRangeKey_4, String globalSecondaryIndexRangeType_4, long globalSecondaryIndexInitialReadCap_4, long globalSecondaryIndexInitialWriteCap_4, String globalSecondaryIndexName_5, String globalSecondaryIndexHashKey_5, String globalSecondaryIndexHashType_5, String globalSecondaryIndexRangeKey_5, String globalSecondaryIndexRangeType_5, long globalSecondaryIndexInitialReadCap_5, long globalSecondaryIndexInitialWriteCap_5) {
        logger.info("createTable() : table : " + finalTableName);
        ArrayList<KeySchemaElement> keys = new ArrayList<KeySchemaElement>();
        ArrayList<AttributeDefinition> attributeDefinitionList = new ArrayList<AttributeDefinition>();
        KeySchemaElement keySchemaElement = new KeySchemaElement().withKeyType(KeyType.HASH).withAttributeName("ID");
        keys.add(keySchemaElement);
        AttributeDefinition attributeDefinition = new AttributeDefinition().withAttributeName("ID").withAttributeType(ScalarAttributeType.S);
        attributeDefinitionList.add(attributeDefinition);
        ArrayList<LocalSecondaryIndex> localSecondaryIndexes = new ArrayList<LocalSecondaryIndex>();
        if (!rangeKeyName.equals("WITHOUT_RANGE_KEY")) {
            KeySchemaElement rangeSchemaElement = new KeySchemaElement().withKeyType(KeyType.RANGE).withAttributeName(rangeKeyName);
            keys.add(rangeSchemaElement);
            ScalarAttributeType keyType = ScalarAttributeType.S;
            if (rangeKeyType.equals("RANGE_KEY_TYPE_NUMBER")) {
                keyType = ScalarAttributeType.N;
            }
            AttributeDefinition rangeAttributeDefinition = new AttributeDefinition().withAttributeName(rangeKeyName).withAttributeType(keyType);
            attributeDefinitionList.add(rangeAttributeDefinition);
            this.createLocalSecondaryIndex(localSecondaryIndexName_1, localSecondaryIndexType_1, keySchemaElement, attributeDefinitionList, localSecondaryIndexes);
            this.createLocalSecondaryIndex(localSecondaryIndexName_2, localSecondaryIndexType_2, keySchemaElement, attributeDefinitionList, localSecondaryIndexes);
            this.createLocalSecondaryIndex(localSecondaryIndexName_3, localSecondaryIndexType_3, keySchemaElement, attributeDefinitionList, localSecondaryIndexes);
            this.createLocalSecondaryIndex(localSecondaryIndexName_4, localSecondaryIndexType_4, keySchemaElement, attributeDefinitionList, localSecondaryIndexes);
            this.createLocalSecondaryIndex(localSecondaryIndexName_5, localSecondaryIndexType_5, keySchemaElement, attributeDefinitionList, localSecondaryIndexes);
        }
        ArrayList<GlobalSecondaryIndex> globalSecondaryIndexList = new ArrayList<GlobalSecondaryIndex>();
        GlobalSecondaryIndex gsi = this.createGlobalSecondaryIndex(globalSecondaryIndexName_1, globalSecondaryIndexHashKey_1, globalSecondaryIndexHashType_1, globalSecondaryIndexRangeKey_1, globalSecondaryIndexRangeType_1, globalSecondaryIndexInitialReadCap_1, globalSecondaryIndexInitialWriteCap_1, attributeDefinitionList);
        if (gsi != null) {
            globalSecondaryIndexList.add(gsi);
        }
        if ((gsi = this.createGlobalSecondaryIndex(globalSecondaryIndexName_2, globalSecondaryIndexHashKey_2, globalSecondaryIndexHashType_2, globalSecondaryIndexRangeKey_2, globalSecondaryIndexRangeType_2, globalSecondaryIndexInitialReadCap_2, globalSecondaryIndexInitialWriteCap_2, attributeDefinitionList)) != null) {
            globalSecondaryIndexList.add(gsi);
        }
        if ((gsi = this.createGlobalSecondaryIndex(globalSecondaryIndexName_3, globalSecondaryIndexHashKey_3, globalSecondaryIndexHashType_3, globalSecondaryIndexRangeKey_3, globalSecondaryIndexRangeType_3, globalSecondaryIndexInitialReadCap_3, globalSecondaryIndexInitialWriteCap_3, attributeDefinitionList)) != null) {
            globalSecondaryIndexList.add(gsi);
        }
        if ((gsi = this.createGlobalSecondaryIndex(globalSecondaryIndexName_4, globalSecondaryIndexHashKey_4, globalSecondaryIndexHashType_4, globalSecondaryIndexRangeKey_4, globalSecondaryIndexRangeType_4, globalSecondaryIndexInitialReadCap_4, globalSecondaryIndexInitialWriteCap_4, attributeDefinitionList)) != null) {
            globalSecondaryIndexList.add(gsi);
        }
        if ((gsi = this.createGlobalSecondaryIndex(globalSecondaryIndexName_5, globalSecondaryIndexHashKey_5, globalSecondaryIndexHashType_5, globalSecondaryIndexRangeKey_5, globalSecondaryIndexRangeType_5, globalSecondaryIndexInitialReadCap_5, globalSecondaryIndexInitialWriteCap_5, attributeDefinitionList)) != null) {
            globalSecondaryIndexList.add(gsi);
        }
        ProvisionedThroughput throughput = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCap)).withWriteCapacityUnits(Long.valueOf(writeCap));
        CreateTableRequest createTableRequest = new CreateTableRequest().withTableName(finalTableName).withKeySchema(keys).withAttributeDefinitions(attributeDefinitionList).withProvisionedThroughput(throughput);
        if (localSecondaryIndexes != null && !localSecondaryIndexes.isEmpty()) {
            createTableRequest = createTableRequest.withLocalSecondaryIndexes(localSecondaryIndexes);
        }
        if (!globalSecondaryIndexList.isEmpty()) {
            createTableRequest = createTableRequest.withGlobalSecondaryIndexes(globalSecondaryIndexList);
        }
        this.dbClient.createTable(createTableRequest).getTableDescription();
        Tables.waitForTableToBecomeActive((AmazonDynamoDB)this.dbClient, (String)finalTableName);
    }

    @Override
    public void updateTable(String finalTableName, long readCap, long writeCap, long oldReadCap, long oldWriteCap) {
        long tmpReadCap = oldReadCap;
        long tmpWriteCap = oldWriteCap;
        do {
            tmpReadCap = 2L * tmpReadCap;
            tmpWriteCap = 2L * tmpWriteCap;
            if (tmpReadCap > readCap) {
                tmpReadCap = readCap;
            }
            if (tmpWriteCap > writeCap) {
                tmpWriteCap = writeCap;
            }
            logger.info("updateTable() : table : " + finalTableName + " : finalReadCap :" + readCap + " finalWriteCap : " + writeCap + " newReadCap : " + Long.toString(tmpReadCap) + " newWriteCap : " + Long.toString(tmpWriteCap));
            ProvisionedThroughput newThroughtput = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(tmpReadCap)).withWriteCapacityUnits(Long.valueOf(tmpWriteCap));
            UpdateTableRequest updateTableRequest = new UpdateTableRequest().withTableName(finalTableName).withProvisionedThroughput(newThroughtput);
            this.dbClient.updateTable(updateTableRequest).getTableDescription();
            Tables.waitForTableToBecomeActive((AmazonDynamoDB)this.dbClient, (String)finalTableName);
        } while (tmpReadCap < readCap || tmpWriteCap < writeCap);
    }

    @Override
    public Map<String, Map<String, Long>> listTablesWithProperties() {
        logger.info("listTablesWithProperties()");
        HashMap<String, Map<String, Long>> resultMap = new HashMap<String, Map<String, Long>>();
        String lastEvaluatedTable = null;
        do {
            ListTablesRequest listTablesRequest = new ListTablesRequest().withLimit(Integer.valueOf(10)).withExclusiveStartTableName(lastEvaluatedTable);
            ListTablesResult result = this.dbClient.listTables(listTablesRequest);
            lastEvaluatedTable = result.getLastEvaluatedTableName();
            for (String name : result.getTableNames()) {
                DescribeTableRequest describeTableRequest = new DescribeTableRequest().withTableName(name);
                TableDescription tableDescription = this.dbClient.describeTable(describeTableRequest).getTable();
                Long readCap = tableDescription.getProvisionedThroughput().getReadCapacityUnits();
                Long writeCap = tableDescription.getProvisionedThroughput().getWriteCapacityUnits();
                HashMap<String, Long> capResult = new HashMap<String, Long>();
                capResult.put("READ_CAP_NAME", readCap);
                capResult.put("WRITE_CAP_NAME", writeCap);
                resultMap.put(name, capResult);
            }
        } while (lastEvaluatedTable != null);
        return resultMap;
    }
}

