/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dynamo.db.lib.exceptions;

import com.amazonaws.AmazonServiceException;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errors {
    CONDITIONAL_ERROR(Sets.newHashSet((Object[])new String[]{"ConditionalCheckFailedException"})),
    THROUGHPUT_ERROR(Sets.newHashSet((Object[])new String[]{"ProvisionedThroughputExceededException"})),
    SERVICE_ERROR(Sets.newHashSet((Object[])new String[]{"InternalFailure", "InternalServerError", "ServiceUnavailableException"})),
    DO_NOT_TOUCH(new HashSet<String>());

    private Set<String> errorCodes;

    private Errors(Set<String> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public static Errors fromAmazonServiceException(AmazonServiceException exception) {
        if (Errors.CONDITIONAL_ERROR.errorCodes.contains(exception.getErrorCode())) {
            return CONDITIONAL_ERROR;
        }
        if (Errors.THROUGHPUT_ERROR.errorCodes.contains(exception.getErrorCode())) {
            return THROUGHPUT_ERROR;
        }
        if (Errors.SERVICE_ERROR.errorCodes.contains(exception.getErrorCode())) {
            return SERVICE_ERROR;
        }
        return DO_NOT_TOUCH;
    }
}

