/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.commons.identity;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.commons.identity.codec.Base16Coder;

public class SessionIdGenerator {
    public static String createId(String uniqueId, String accountId) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(uniqueId);
        buffer.append(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(buffer.toString().getBytes("UTF-8"));
            return Base16Coder.encodeBytes(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Cant find algorithm for sessionId digest", accountId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unsupported encoding UTF-8", accountId);
        }
    }
}

