/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.commons.identity;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.util.Arrays;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import ru.quadcom.commons.exceptions.UnauthorizedException;
import ru.quadcom.commons.identity.codec.Base16Coder;
import ru.quadcom.commons.identity.codec.Crypt;
import ru.quadcom.commons.identity.codec.Hash;
import ru.quadcom.commons.identity.service.to.service.ServicesSecrets;

public class ServiceToServiceToken {
    private static final int CURRENT_VERSION = 1;
    public static final int ACCESS_TOKEN_EXPIRATION = 600;
    private String serviceName;
    private Date creationTime;
    private Date expirationTime;

    public ServiceToServiceToken() {
    }

    private ServiceToServiceToken(byte[] tokenByteArray) {
        ServiceToServiceToken tmpToken = new ServiceToServiceToken();
        Schema tokenSchema = RuntimeSchema.getSchema(ServiceToServiceToken.class);
        ProtostuffIOUtil.mergeFrom((byte[])tokenByteArray, (Object)tmpToken, (Schema)tokenSchema);
        this.serviceName = tmpToken.serviceName;
        this.creationTime = tmpToken.creationTime;
        this.expirationTime = tmpToken.expirationTime;
    }

    private ServiceToServiceToken(String serviceName) {
        this.serviceName = serviceName;
        this.creationTime = DateTime.now().toDate();
        this.expirationTime = new DateTime((Object)this.creationTime).plusSeconds(600).toDate();
    }

    public static ServiceToServiceToken createAccessToken(ServicesSecrets secret) {
        ServiceToServiceToken token = new ServiceToServiceToken(secret.serviceName());
        return token;
    }

    public static ServiceToServiceToken decode(String encodeToken, ServicesSecrets secret) {
        if (encodeToken == null || encodeToken.isEmpty()) {
            throw new UnauthorizedException("Empty or null Access Token", null);
        }
        try {
            Crypt crypt = new Crypt("YAy9GYHrbnRCVbdddXEJLYqWX4Mnf6dDVbwEBKerZgQAYSzCRFHsfC3PWnyCJXSERAYqc9cLyTb2jvhGnxEXFZWEc26XrUeyMscJHccKYgZ5vLz3rVnmaTyp", secret.serviceSecret());
            byte[] temp = ServiceToServiceToken.verifyAndRemoveSignature(crypt.decrypt(ServiceToServiceToken.symmetricScramble(Base16Coder.decodeBytes(encodeToken))));
            return new ServiceToServiceToken(temp);
        }
        catch (Exception e) {
            throw new UnauthorizedException("Decode access token failed", e, null);
        }
    }

    private static byte[] symmetricScramble(byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)(value[i] ^ 79 + i * 12 & 0xFF);
        }
        return value;
    }

    private static byte[] verifyAndRemoveSignature(byte[] encodedValueWithSignature) {
        byte[] signature = new byte[16];
        int length = encodedValueWithSignature.length;
        for (int i = 0; i < 8; ++i) {
            signature[i] = encodedValueWithSignature[length - i - 1];
            signature[i + 8] = encodedValueWithSignature[i];
        }
        byte[] encodedValueWithoutSignature = Arrays.copyOfRange(encodedValueWithSignature, 8, length - 8);
        byte[] calculatedSignature = Hash.sha1.hash(encodedValueWithoutSignature);
        for (int i = 0; i < 16; ++i) {
            if (signature[i] == calculatedSignature[i]) continue;
            throw new UnauthorizedException("Failed to deserialize service to service token, attempted tampering.", null);
        }
        return encodedValueWithoutSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(ServicesSecrets secret) {
        Schema tokenSchema = RuntimeSchema.getSchema(ServiceToServiceToken.class);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Crypt crypt = new Crypt("YAy9GYHrbnRCVbdddXEJLYqWX4Mnf6dDVbwEBKerZgQAYSzCRFHsfC3PWnyCJXSERAYqc9cLyTb2jvhGnxEXFZWEc26XrUeyMscJHccKYgZ5vLz3rVnmaTyp", secret.serviceSecret());
            byte[] serialized = ProtostuffIOUtil.toByteArray((Object)this, (Schema)tokenSchema, (LinkedBuffer)buffer);
            String string = Base16Coder.encodeBytes(ServiceToServiceToken.symmetricScramble(crypt.encrypt(ServiceToServiceToken.signAndAddSignature(serialized))));
            return string;
        }
        finally {
            buffer.clear();
        }
    }

    private static byte[] signAndAddSignature(byte[] encodedValueWithoutSignature) {
        byte[] encodedValueWithSignature = new byte[encodedValueWithoutSignature.length + 16];
        byte[] calculatedSignature = Hash.sha1.hash(encodedValueWithoutSignature);
        int length = encodedValueWithSignature.length;
        for (int i = 0; i < 8; ++i) {
            encodedValueWithSignature[length - i - 1] = calculatedSignature[i];
            encodedValueWithSignature[i] = calculatedSignature[i + 8];
        }
        System.arraycopy(encodedValueWithoutSignature, 0, encodedValueWithSignature, 8, encodedValueWithoutSignature.length);
        return encodedValueWithSignature;
    }

    public boolean isExpired() {
        return new DateTime((Object)this.expirationTime).isBefore((ReadableInstant)DateTime.now());
    }

    public int getExpiresIn() {
        long diff = new DateTime((Object)this.expirationTime).getMillis() - new DateTime((Object)this.creationTime).getMillis();
        return (int)(diff / 1000L);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public DateTime getCreationTime() {
        return new DateTime((Object)this.creationTime);
    }

    public DateTime getExpirationTime() {
        return new DateTime((Object)this.expirationTime);
    }
}

