/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.cassandra.utils;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.core.schemabuilder.UDTType;
import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Defaults;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.datastax.driver.mapping.annotations.UDT;
import com.google.common.base.CaseFormat;
import com.google.common.base.Predicate;
import com.stratio.cassandra.lucene.builder.Builder;
import com.stratio.cassandra.lucene.builder.index.Index;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.Mapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.database.lib.cassandra.annotations.ClusteringOrder;
import ru.quadcom.database.lib.cassandra.annotations.LuceneField;
import ru.quadcom.database.lib.cassandra.annotations.LuceneIndex;
import ru.quadcom.database.lib.cassandra.annotations.Secondary;
import ru.quadcom.database.lib.cassandra.annotations.TTL;
import ru.quadcom.database.lib.cassandra.exceptions.TableAnnotationNotFoundCassandraRuntimeException;
import ru.quadcom.database.lib.cassandra.exceptions.UnsupportedCassandraIndexTypeException;
import ru.quadcom.database.lib.cassandra.impl.CassandraClient;

public class CassandraUtils {
    private static final Logger logger = LoggerFactory.getLogger(CassandraUtils.class);
    private static Reflections reflect;
    private static Map<Class<?>, UDT> customTypes;
    private static Map<Class<?>, Table> tables;

    public static void InitTables(CassandraClient client, String searchPath) {
        reflect = new Reflections(searchPath, new Scanner[0]);
        customTypes.clear();
        for (Class clazz : reflect.getTypesAnnotatedWith(UDT.class)) {
            UDT udt = clazz.getAnnotation(UDT.class);
            customTypes.put(clazz, udt);
        }
        tables.clear();
        for (Class clazz : reflect.getTypesAnnotatedWith(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            tables.put(clazz, table);
        }
        if (tables.size() == 0) {
            logger.warn("CassandraUtils: no table beans found in " + searchPath);
            return;
        }
        client.getSession().thenComposeAsync(session -> {
            ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
            for (Class<?> type : CassandraUtils.orderUdt(customTypes)) {
                logger.debug("Checking custom type: " + type.toString());
                tasks.add(CassandraUtils.checkAndCreateCustomType(client, session, type));
            }
            for (Class<?> table : tables.keySet()) {
                logger.debug("Checking table: " + table.toString());
                Field[] keyFields = CassandraUtils.getPartitionKeys(table);
                if (keyFields.length == 0) continue;
                tasks.add(CassandraUtils.checkAndCreateTable(client, session, table, keyFields));
            }
            return tasks.size() > 0 ? CompletableFuture.allOf(tasks.toArray(new CompletableFuture[tasks.size()])) : CompletableFuture.completedFuture(null);
        }).exceptionally(problem -> {
            logger.error("CassandraUtils initTable Error: ", problem);
            return null;
        });
    }

    public static String getTableName(Class table) {
        if (!tables.containsKey(table)) {
            throw new TableAnnotationNotFoundCassandraRuntimeException("No annotation @CassandraTable present in " + table.toString());
        }
        return tables.get(table).name();
    }

    public static String getCustomTypeName(Class type) {
        return customTypes.get(type).name();
    }

    public static String getIndexName(Class table) {
        if (!table.isAnnotationPresent(LuceneIndex.class)) {
            throw new TableAnnotationNotFoundCassandraRuntimeException("No annotation @LuceneIndex present in " + table.toString());
        }
        LuceneIndex ci = table.getAnnotation(LuceneIndex.class);
        return ci.name();
    }

    private static CompletableFuture<Void> checkAndCreateCustomType(CassandraClient client, Session session, Class type) {
        String typeName = customTypes.get(type).name();
        logger.debug("Type name: " + typeName);
        return CompletableFuture.supplyAsync(() -> {
            try {
                logger.debug("Creating UDT " + typeName);
                String createDDL = CassandraUtils.generateTypeDDL(type, typeName);
                logger.info("Running DDL: " + createDDL);
                session.execute(createDDL);
            }
            catch (Exception e) {
                logger.error("Error creating UDT DDL for " + typeName, (Throwable)e);
            }
            return null;
        });
    }

    private static CompletableFuture<Void> checkAndCreateTable(CassandraClient client, Session session, Class table, Field[] partitionKeys) {
        String tableName = CassandraUtils.getTableName(table);
        Field[] clusteringKeys = CassandraUtils.getClusteringKeys(table);
        logger.debug("Table name: " + tableName + " primary keys count: " + partitionKeys.length + " clustering keys count: " + clusteringKeys.length);
        return client.isTableExists(tableName).thenAcceptAsync(exists -> {
            if (!exists.booleanValue()) {
                logger.debug("Creating table " + tableName + " exists");
                String createDDL = CassandraUtils.generateDDL(table, tableName);
                logger.info("Running DDL: " + createDDL);
                session.execute(createDDL);
            } else {
                logger.debug("Table " + tableName + " exists");
            }
        }).thenComposeAsync(ignore -> {
            String luceneIndexName = CassandraUtils.getLuceneIndex(table);
            if (luceneIndexName != null) {
                return client.getIndexOptions(tableName, luceneIndexName).thenApplyAsync(options -> {
                    String indexDDL = CassandraUtils.makeLuceneIndexDDL(table, tableName, luceneIndexName);
                    if (options == null) {
                        logger.info("Running lucene index DDL: " + indexDDL);
                        session.execute(indexDDL);
                    } else {
                        logger.debug("Table " + tableName + " index " + luceneIndexName + " exists");
                    }
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        }).thenAcceptAsync(ignore -> {
            Map<String, String> secondary_indexes = CassandraUtils.getSecondaryIndexes(table);
            if (secondary_indexes != null && secondary_indexes.size() > 0) {
                for (Map.Entry<String, String> index : secondary_indexes.entrySet()) {
                    SchemaStatement builder = SchemaBuilder.createIndex((String)index.getKey()).ifNotExists().onTable(tableName).andColumn(index.getValue());
                    logger.info("Running secondary index DDL: " + builder.getQueryString());
                    session.execute((Statement)builder);
                }
            }
        }).toCompletableFuture();
    }

    private static String makeLuceneIndexDDL(Class table, String tableName, String indexName) {
        LuceneIndex index = table.getAnnotation(LuceneIndex.class);
        Index indexBuilder = Builder.index((String)tableName, (String)indexName).refreshSeconds((Number)index.refreshSeconds());
        for (Field field : ReflectionUtils.getAllFields((Class)table, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(LuceneField.class)})) {
            indexBuilder.mapper(CassandraUtils.toCassandraColumnName(field.getName()), CassandraUtils.getIndexTypeMapper(field.getType()));
        }
        return indexBuilder.toString();
    }

    private static String getLuceneIndex(Class table) {
        if (!table.isAnnotationPresent(LuceneIndex.class)) {
            return null;
        }
        LuceneIndex index = table.getAnnotation(LuceneIndex.class);
        return index.name();
    }

    private static Map<String, String> getSecondaryIndexes(Class table) {
        HashMap<String, String> names = new HashMap<String, String>();
        for (Field field : ReflectionUtils.getAllFields((Class)table, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Secondary.class)})) {
            names.put(field.getAnnotation(Secondary.class).indexName(), CassandraUtils.getSecondaryKeyName(field));
        }
        return names;
    }

    private static Field[] getPartitionKeys(Class table) {
        Set primary = ReflectionUtils.getAllFields((Class)table, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(PartitionKey.class)});
        if (primary.size() == 0) {
            logger.error("CassandraUtils: Found zero partition keys in " + table.toString());
            return new Field[0];
        }
        Field[] keys = new Field[primary.size()];
        return primary.toArray(keys);
    }

    protected static Field[] getClusteringKeys(Class table) {
        ArrayList orderedFields = new ArrayList(ReflectionUtils.getAllFields((Class)table, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(ClusteringColumn.class)}));
        if (orderedFields.size() > 1) {
            for (Field f12 : orderedFields) {
                ClusteringColumn cc1 = f12.getAnnotation(ClusteringColumn.class);
                for (Field f22 : orderedFields) {
                    if (f12.equals(f22)) continue;
                    ClusteringColumn cc2 = f22.getAnnotation(ClusteringColumn.class);
                    if (cc1.value() != cc2.value()) continue;
                    throw new IllegalArgumentException(String.format("Clustering column order duplicated in %s[%s and %s]", table.getCanonicalName(), f12.getName(), f22.getName()));
                }
            }
            Collections.sort(orderedFields, (f1, f2) -> {
                ClusteringColumn cc1 = f1.getAnnotation(ClusteringColumn.class);
                ClusteringColumn cc2 = f2.getAnnotation(ClusteringColumn.class);
                return cc1.value() - cc2.value();
            });
        }
        Field[] keys = new Field[orderedFields.size()];
        return orderedFields.toArray(keys);
    }

    private static String getColumnName(Field field) {
        Column p = field.getAnnotation(Column.class);
        return CassandraUtils.toCassandraColumnName(p == null || p.name().trim().isEmpty() ? field.getName() : p.name());
    }

    private static String getSecondaryKeyName(Field field) {
        Secondary s = field.getAnnotation(Secondary.class);
        return CassandraUtils.toCassandraColumnName(s.name().equals("") ? field.getName() : s.name());
    }

    static String generateTypeDDL(Class typeClass, String typeName) {
        CreateType create = (CreateType)SchemaBuilder.createType((String)typeName).ifNotExists();
        for (Field field : typeClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.codec() != Defaults.NoCodec.class) {
                try {
                    Class clazz = column.codec();
                    Constructor ctor = clazz.getDeclaredConstructor(new Class[0]);
                    create.addColumn(CassandraUtils.toCassandraColumnName(field.getName()), ((TypeCodec)ctor.newInstance(new Object[0])).getCqlType());
                }
                catch (Exception e) {
                    logger.error("Error getting type codec from Column in UDT class: " + typeClass);
                    create.addColumn(CassandraUtils.toCassandraColumnName(field.getName()), CassandraUtils.getCassandraType(field.getGenericType()));
                }
                continue;
            }
            if (customTypes.containsKey(field.getType())) {
                String udtName = customTypes.get(field.getType()).name();
                create.addUDTColumn(CassandraUtils.toCassandraColumnName(field.getName()), SchemaBuilder.frozen((String)udtName));
                continue;
            }
            Class<?> c = field.getType();
            create.addColumn(CassandraUtils.toCassandraColumnName(field.getName()), CassandraUtils.getCassandraType(field.getGenericType()));
        }
        return create.buildInternal();
    }

    static String generateDDL(Class table, String tableName) {
        Create create = (Create)SchemaBuilder.createTable((String)tableName).ifNotExists();
        for (Field field : table.getDeclaredFields()) {
            DataType type;
            if (Modifier.isStatic(field.getModifiers())) continue;
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.codec() != Defaults.NoCodec.class) {
                try {
                    Class clazz = column.codec();
                    Constructor ctor = clazz.getDeclaredConstructor(new Class[0]);
                    type = ((TypeCodec)ctor.newInstance(new Object[0])).getCqlType();
                }
                catch (Exception e) {
                    logger.error("Error getting type codec from Column in Table class: " + table);
                    type = CassandraUtils.getCassandraType(field.getGenericType());
                }
            } else {
                type = CassandraUtils.getCassandraType(field.getGenericType());
            }
            if (type == null) {
                create.addUDTListColumn(CassandraUtils.toCassandraColumnName(field.getName()), CassandraUtils.getUdtCassandraList(field.getGenericType()));
                continue;
            }
            if (field.isAnnotationPresent(PartitionKey.class)) {
                create.addPartitionKey(CassandraUtils.getColumnName(field), type);
                continue;
            }
            if (field.isAnnotationPresent(ClusteringColumn.class)) {
                create.addClusteringColumn(CassandraUtils.getColumnName(field), type);
                continue;
            }
            if (customTypes.containsKey(field.getType())) {
                String udtName = customTypes.get(field.getType()).name();
                create.addUDTColumn(CassandraUtils.toCassandraColumnName(field.getName()), SchemaBuilder.frozen((String)udtName));
                continue;
            }
            create.addColumn(CassandraUtils.toCassandraColumnName(field.getName()), type);
        }
        Create.Options tableOptions = create.withOptions();
        boolean affectedByOptions = false;
        if (table.isAnnotationPresent(ClusteringOrder.class)) {
            affectedByOptions = true;
            ClusteringOrder options = table.getAnnotation(ClusteringOrder.class);
            tableOptions.clusteringOrder(CassandraUtils.toCassandraColumnName(options.columName()), options.order());
        }
        if (table.isAnnotationPresent(TTL.class)) {
            affectedByOptions = true;
            TTL ttl = table.getAnnotation(TTL.class);
            tableOptions.defaultTimeToLive(Integer.valueOf(ttl.seconds()));
        }
        if (affectedByOptions) {
            return tableOptions.getQueryString();
        }
        return create.getQueryString();
    }

    private static String getCassandraTypeStr(Class type) {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return "int";
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return "bigint";
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return "float";
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return "boolean";
        }
        if (UUID.class.isAssignableFrom(type)) {
            return "uuid";
        }
        if (List.class.isAssignableFrom(type)) {
            return "list";
        }
        if (Properties.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            return "map<varchar,varchar>";
        }
        if (String.class.isAssignableFrom(type)) {
            return "varchar";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "varchar";
        }
        return "varchar";
    }

    private static DataType getCassandraType(Type type) {
        Class clazz;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new IllegalArgumentException(type.getTypeName());
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return DataType.cint();
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return DataType.decimal();
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return DataType.bigint();
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return DataType.cfloat();
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return DataType.cboolean();
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return DataType.uuid();
        }
        if (String.class.isAssignableFrom(clazz)) {
            return DataType.varchar();
        }
        if (Properties.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            return DataType.map((DataType)DataType.varchar(), (DataType)DataType.varchar());
        }
        if (List.class.isAssignableFrom(clazz)) {
            return CassandraUtils.getCommonCassandraList(type);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DataType.varchar();
        }
        if (customTypes.containsKey(clazz)) {
            String udtName = customTypes.get(clazz).name();
            return DataType.custom((String)udtName);
        }
        throw new UnsupportedCassandraIndexTypeException("Unknown index type: " + clazz.toString());
    }

    private static DataType getCommonCassandraList(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("ParametrizedType expected: " + type);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getActualTypeArguments().length != 1) {
            throw new IllegalArgumentException("generic's type count != 1");
        }
        Type paramType = parameterizedType.getActualTypeArguments()[0];
        DataType dt = CassandraUtils.getCassandraType(paramType);
        return DataType.list((DataType)dt);
    }

    private static UDTType getUdtCassandraList(Type type) {
        Class clazz;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new IllegalArgumentException(type.getTypeName());
        }
        if (List.class.isAssignableFrom(clazz)) {
            Class paramClazz;
            if (!(type instanceof ParameterizedType)) {
                throw new IllegalArgumentException("ParametrizedType expected: " + type);
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getActualTypeArguments().length != 1) {
                throw new IllegalArgumentException("generic's type count != 1");
            }
            Type paramType = parameterizedType.getActualTypeArguments()[0];
            if (paramType instanceof Class) {
                paramClazz = (Class)paramType;
            } else if (paramType instanceof ParameterizedType) {
                paramClazz = (Class)((ParameterizedType)paramType).getRawType();
            } else {
                throw new IllegalArgumentException(paramType.getTypeName());
            }
            if (customTypes.containsKey(paramClazz)) {
                String udtName = customTypes.get(paramClazz).name();
                return SchemaBuilder.frozen((String)udtName);
            }
        }
        throw new UnsupportedCassandraIndexTypeException("Unknown index type: " + clazz.toString());
    }

    private static Mapper getIndexTypeMapper(Class type) {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Builder.integerMapper();
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return Builder.bigDecimalMapper();
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Builder.bigIntegerMapper();
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Builder.floatMapper();
        }
        if (String.class.isAssignableFrom(type)) {
            return Builder.stringMapper();
        }
        if (UUID.class.isAssignableFrom(type)) {
            return Builder.uuidMapper();
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Builder.booleanMapper();
        }
        if (Properties.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            throw new UnsupportedCassandraIndexTypeException("Map or Properties classes not supported");
        }
        if (Date.class.isAssignableFrom(type)) {
            return Builder.stringMapper();
        }
        throw new UnsupportedCassandraIndexTypeException("Unknown index type: " + type.toString());
    }

    public static String toCassandraColumnName(String javaField) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, javaField);
    }

    private static String fromCassandraColumnName(String cassandraField) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, cassandraField);
    }

    static List<Class<?>> orderUdt(Map<Class<?>, UDT> customTypes) {
        ArrayList orderedItems = new ArrayList(customTypes.keySet());
        HashMap counter = new HashMap();
        for (Class<?> t : customTypes.keySet()) {
            counter.put(t, CassandraUtils.countNestedUdts(t, customTypes));
        }
        Collections.sort(orderedItems, (o1, o2) -> (Integer)counter.get(o1) - (Integer)counter.get(o2));
        return orderedItems;
    }

    private static int countNestedUdts(Class type, Map<Class<?>, UDT> customTypes) {
        int counter = 0;
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Column column = field.getAnnotation(Column.class);
            if (!customTypes.containsKey(field.getType())) continue;
            ++counter;
        }
        return counter;
    }

    static Map<Class<?>, UDT> getCustomTypesCopy() {
        return Collections.unmodifiableMap(customTypes);
    }

    static {
        customTypes = new HashMap();
        tables = new HashMap();
    }
}

