/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.cassandra.utils;

import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.stratio.cassandra.lucene.builder.Builder;
import com.stratio.cassandra.lucene.builder.search.condition.ContainsCondition;
import com.stratio.cassandra.lucene.builder.search.condition.MatchCondition;
import com.stratio.cassandra.lucene.builder.search.condition.PrefixCondition;
import com.stratio.cassandra.lucene.builder.search.condition.RangeCondition;
import java.util.List;
import ru.quadcom.database.lib.cassandra.utils.CassandraUtils;

public class CassandraQueryUtils {
    public static Clause eq(String name, Object value) {
        return QueryBuilder.eq((String)CassandraUtils.toCassandraColumnName(name), (Object)value);
    }

    public static Clause lt(String name, Object value) {
        return QueryBuilder.lt((String)CassandraUtils.toCassandraColumnName(name), (Object)value);
    }

    public static Clause lte(String name, Object value) {
        return QueryBuilder.lte((String)CassandraUtils.toCassandraColumnName(name), (Object)value);
    }

    public static Clause gte(String name, Object value) {
        return QueryBuilder.gte((String)CassandraUtils.toCassandraColumnName(name), (Object)value);
    }

    public static Clause gt(String name, Object value) {
        return QueryBuilder.gt((String)CassandraUtils.toCassandraColumnName(name), (Object)value);
    }

    public static Clause in(String name, List<?> value) {
        return QueryBuilder.in((String)CassandraUtils.toCassandraColumnName(name), value);
    }

    public static MatchCondition luceneEq(String name, Object value) {
        return Builder.match((String)CassandraUtils.toCassandraColumnName(name), (Object)value);
    }

    public static RangeCondition luceneRangeUpper(String name, Object upper, boolean includeUpper) {
        return Builder.range((String)CassandraUtils.toCassandraColumnName(name)).upper(upper).includeUpper(Boolean.valueOf(includeUpper));
    }

    public static RangeCondition luceneRangeLower(String name, Object lower, boolean includeLower) {
        return Builder.range((String)CassandraUtils.toCassandraColumnName(name)).lower(lower).includeLower(Boolean.valueOf(includeLower));
    }

    public static RangeCondition luceneRange(String name, Object lower, Object upper, boolean includeLower, boolean includeUpper) {
        return Builder.range((String)CassandraUtils.toCassandraColumnName(name)).lower(lower).includeLower(Boolean.valueOf(includeLower)).upper(upper).includeUpper(Boolean.valueOf(includeUpper));
    }

    public static PrefixCondition lucenePrefix(String name, String prefix) {
        return Builder.prefix((String)CassandraUtils.toCassandraColumnName(name), (String)prefix);
    }

    public static ContainsCondition luceneIn(String name, List<?> value) {
        return Builder.contains((String)CassandraUtils.toCassandraColumnName(name), (Object[])value.toArray(new Object[value.size()]));
    }
}

