/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.cassandra.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.collect.ImmutableList;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stratio.cassandra.lucene.builder.Builder;
import com.stratio.cassandra.lucene.builder.search.Search;
import com.stratio.cassandra.lucene.builder.search.condition.BooleanCondition;
import com.stratio.cassandra.lucene.builder.search.condition.Condition;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import ru.quadcom.database.lib.cassandra.exceptions.ParamInvalidCassandraRuntimeException;
import ru.quadcom.database.lib.cassandra.interfaces.ICassandraClient;
import ru.quadcom.database.lib.cassandra.interfaces.ICassandraSearchService;
import ru.quadcom.database.lib.cassandra.responses.SearchResponse;
import ru.quadcom.database.lib.cassandra.utils.CassandraUtils;

public class CassandraSearchService
implements ICassandraSearchService {
    private final ICassandraClient cassandraClient;
    private final Gson gson;

    @Inject
    public CassandraSearchService(@Nullable ICassandraClient cassandraClient) {
        this.cassandraClient = cassandraClient;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    @Override
    public <T> CompletionStage<SearchResponse<T>> searchMatch(Class<T> clazz, int limit, List<Clause> clauses) {
        return this.cassandraClient.getSession().thenApplyAsync(session -> {
            String tableName = CassandraUtils.getTableName(clazz);
            Select select = QueryBuilder.select().json().all().from(tableName).limit(limit);
            for (Clause clause : clauses) {
                select.where(clause);
            }
            ResultSet rs = session.execute((Statement)select);
            List rows = rs.all();
            ArrayList<Object> objs = new ArrayList<Object>();
            for (Row row : rows) {
                String valueString = row.getString(0);
                objs.add(this.gson.fromJson(valueString, clazz));
            }
            return new SearchResponse(objs);
        });
    }

    @Override
    public <T> CompletionStage<SearchResponse<T>> searchMatch(Class<T> clazz, int limit, Object ... keys) {
        return this.cassandraClient.getSession().thenComposeAsync(session -> {
            if (keys.length < 2 || keys.length % 2 != 0) {
                throw new ParamInvalidCassandraRuntimeException("Filtering parameters count didn't match %2");
            }
            ArrayList<Clause> clauses = new ArrayList<Clause>();
            for (int i = 0; i < keys.length; i += 2) {
                clauses.add(QueryBuilder.eq((String)CassandraUtils.toCassandraColumnName((String)keys[i]), (Object)keys[i + 1]));
            }
            return this.searchMatch(clazz, limit, clauses);
        });
    }

    @Override
    public <T> CompletionStage<SearchResponse<T>> searchLuceneMatch(Class<T> clazz, int limit, Object ... params) {
        return this.cassandraClient.getSession().thenComposeAsync(session -> {
            if (params.length == 0 || params.length % 2 != 0) {
                throw new ParamInvalidCassandraRuntimeException("Filtering parameters count didn't match %2");
            }
            ArrayList<Condition> conds = new ArrayList<Condition>();
            for (int i = 0; i < params.length; i += 2) {
                conds.add((Condition)Builder.match((String)CassandraUtils.toCassandraColumnName((String)params[i]), (Object)params[i + 1]));
            }
            return this.searchLuceneMatch(clazz, limit, conds);
        });
    }

    @Override
    public <T> CompletionStage<SearchResponse<T>> searchLuceneMatch(Class<T> clazz, int limit, List<Condition> params) {
        return this.searchLuceneMatch(clazz, limit, params, (List<Condition>)ImmutableList.of());
    }

    @Override
    public <T> CompletionStage<SearchResponse<T>> searchLuceneMatch(Class<T> clazz, int limit, List<Condition> params, List<Condition> paramsNot) {
        return this.cassandraClient.getSession().thenApplyAsync(session -> {
            String tableName = CassandraUtils.getTableName(clazz);
            String luceneIndexName = CassandraUtils.getIndexName(clazz);
            String query = "SELECT JSON * FROM " + tableName + " WHERE expr(" + luceneIndexName + ", ?) LIMIT " + limit;
            Condition[] conds = params.toArray(new Condition[params.size()]);
            Condition[] condsNot = params.toArray(new Condition[paramsNot.size()]);
            BooleanCondition condsOverall = Builder.bool().must(conds);
            if (paramsNot.size() > 0) {
                condsOverall.not(condsNot);
            }
            Search luceneSearch = Builder.search().filter((Condition)condsOverall);
            ResultSet rs = session.execute(query, new Object[]{luceneSearch.toString()});
            List rows = rs.all();
            ArrayList<Object> objs = new ArrayList<Object>();
            for (Row row : rows) {
                String valueString = row.getString(0);
                objs.add(this.gson.fromJson(valueString, clazz));
            }
            return new SearchResponse(objs);
        });
    }
}

