/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.cassandra.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.database.lib.cassandra.interfaces.ICassandraClient;

public class CassandraClient
implements ICassandraClient {
    private static final Logger logger = LoggerFactory.getLogger(CassandraClient.class);
    private final List<String> nodes;
    private final int port;
    private final String keySpace;
    private final String user;
    private final String password;
    private final ConsistencyLevel consistencyLevel;
    private Cluster cluster;
    private Session session;

    public CassandraClient(List<String> nodes, int port, String keyspace, String consistencyLevel, String user, String password) {
        this.nodes = nodes;
        this.keySpace = keyspace;
        this.port = port;
        this.user = user;
        this.password = password;
        this.consistencyLevel = ConsistencyLevel.valueOf((String)consistencyLevel);
    }

    private CompletionStage<Cluster> getCluster() {
        if (this.cluster != null && !this.cluster.isClosed()) {
            return CompletableFuture.completedFuture(this.cluster);
        }
        return CompletableFuture.supplyAsync(() -> {
            Cluster.Builder builder = Cluster.builder().addContactPoints(this.nodes.toArray(new String[this.nodes.size()])).withPort(this.port).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(100L)).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE).withQueryOptions(new QueryOptions().setConsistencyLevel(this.consistencyLevel));
            if (this.user != null && !this.user.equals("") && this.password != null && !this.password.equals("")) {
                builder.withCredentials(this.user, this.password);
            }
            this.cluster = builder.build();
            Metadata metadata = this.cluster.getMetadata();
            logger.info(String.format("Connected to Cassandra cluster: %s", metadata.getClusterName()));
            for (Host host : metadata.getAllHosts()) {
                logger.info(String.format("Datacenter: %s; Host: %s; Rack: %s", host.getDatacenter(), host.getAddress(), host.getRack()));
            }
            return this.cluster;
        });
    }

    @Override
    public CompletionStage<Boolean> isTableExists(String tableName) {
        return this.getSession().thenApplyAsync(session -> {
            ResultSet rs = session.execute("SELECT table_name FROM system_schema.tables WHERE keyspace_name='" + this.keySpace + "' AND table_name='" + tableName + "'");
            if (rs.iterator().hasNext()) {
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletionStage<Map<String, String>> getIndexOptions(String tableName, String indexName) {
        return this.getSession().thenApplyAsync(session -> {
            ResultSet rs = session.execute("SELECT options FROM system_schema.indexes WHERE keyspace_name='" + this.keySpace + "' AND table_name='" + tableName + "' AND index_name='" + indexName + "'");
            if (rs.iterator().hasNext()) {
                return rs.one().getMap("options", String.class, String.class);
            }
            return null;
        });
    }

    @Override
    public CompletionStage<Session> getSession() {
        return this.getCluster().thenApplyAsync(cluster -> {
            if (this.session != null && !this.session.isClosed()) {
                return this.session;
            }
            this.session = cluster.connect(this.keySpace);
            return this.session;
        });
    }

    @Override
    public void closeSession() {
        if (this.session == null) {
            return;
        }
        if (!this.session.isClosed()) {
            this.session.close();
        }
        this.session = null;
    }

    @Override
    public void closeCluster() {
        if (this.cluster == null) {
            return;
        }
        if (!this.cluster.isClosed()) {
            this.cluster.close();
        }
        this.cluster = null;
    }
}

