/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.database.lib.cassandra.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import ru.quadcom.database.lib.cassandra.exceptions.ParamInvalidCassandraRuntimeException;
import ru.quadcom.database.lib.cassandra.interfaces.ICassandraClient;
import ru.quadcom.database.lib.cassandra.interfaces.ICassandraKeyValueService;
import ru.quadcom.database.lib.cassandra.responses.DeleteResponse;
import ru.quadcom.database.lib.cassandra.responses.PutResponse;
import ru.quadcom.database.lib.cassandra.utils.CassandraUtils;

public class CassandraKeyValueService
implements ICassandraKeyValueService {
    private final ICassandraClient cassandraClient;
    private final Gson gson;

    @Inject
    public CassandraKeyValueService(@Nullable ICassandraClient cassandraClient) {
        this.cassandraClient = cassandraClient;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    @Override
    public CompletionStage<PutResponse> put(Object obj) {
        return this.cassandraClient.getSession().thenApplyAsync(session -> {
            String tableName = CassandraUtils.getTableName(obj.getClass());
            String json = this.gson.toJson(obj);
            ResultSet rs = session.execute((Statement)QueryBuilder.insertInto((String)tableName).json((Object)json));
            return new PutResponse(rs);
        });
    }

    @Override
    public <T> CompletionStage<DeleteResponse> deleteById(Class<T> clazz, Object ... keys) {
        return this.cassandraClient.getSession().thenApplyAsync(session -> {
            if (keys.length < 2 || keys.length % 2 != 0) {
                throw new ParamInvalidCassandraRuntimeException("Filtering parameters count didn't match %2");
            }
            String tableName = CassandraUtils.getTableName(clazz);
            Delete select = QueryBuilder.delete().from(tableName);
            for (int i = 0; i < keys.length; i += 2) {
                select.where(QueryBuilder.eq((String)CassandraUtils.toCassandraColumnName((String)keys[i]), (Object)keys[i + 1]));
            }
            ResultSet rs = session.execute((Statement)select);
            return new DeleteResponse(rs);
        });
    }
}

