/*
 * Decompiled with CFR 0.152.
 */
package aws.sqs;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchFromQueueActor
extends UntypedActor {
    public static final String ACTOR_NAME = "fetch-messages-from-queue-actor";
    private static final int HOW_LONG_WAIT_BEFORE_NEXT_CIRCLE_IN_MILLISEC = 10;
    private static final int HOW_LONG_WAIT_BEFORE_NEXT_TRY_AFTER_EMPTY_LIST_IN_SECOND = 5;
    private static final int MAX_NUMBER_OF_EMPTY_MESSAGE_LIST = 10;
    private static final Logger logger = LoggerFactory.getLogger(FetchFromQueueActor.class);
    private final String queueUrl;
    private final Region region;
    private final ActorRef father;
    private AmazonSQS sqs;
    private int howManyTimesWeReceiveEmptyMessageList;
    private long startTime;
    private long numberOfMessages;

    private FetchFromQueueActor(String queueUrl, Region region, ActorRef father) {
        this.queueUrl = queueUrl;
        this.region = region;
        this.father = father;
    }

    public void onReceive(Object o) throws Exception {
        if (o instanceof StartFetching || o == ReceiveTimeout.getInstance()) {
            List<Message> messages;
            FiniteDuration finalDuration = null;
            if (o instanceof StartFetching) {
                logger.info("onReceive() : Start fetching messages from queue");
                this.howManyTimesWeReceiveEmptyMessageList = 0;
                this.startTime = System.currentTimeMillis();
                this.numberOfMessages = 0L;
            }
            if ((messages = this.fetchMessagesFromTheQueue(this.queueUrl)) == null || messages.isEmpty()) {
                ++this.howManyTimesWeReceiveEmptyMessageList;
                finalDuration = Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS);
                if (this.howManyTimesWeReceiveEmptyMessageList == 10) {
                    logger.info("Receive empty list 10 times. Stop job.");
                    StopFetching stopFetching = new StopFetching(this.startTime, this.numberOfMessages);
                    this.father.tell((Object)stopFetching, this.getSelf());
                    finalDuration = Duration.Undefined();
                }
            } else {
                finalDuration = Duration.create((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
                this.howManyTimesWeReceiveEmptyMessageList = 0;
                this.numberOfMessages += (long)messages.size();
                FetchedMessageBucket fetchedMessageBucket = new FetchedMessageBucket(messages);
                this.father.tell((Object)fetchedMessageBucket, this.getSelf());
            }
            this.getContext().setReceiveTimeout((Duration)finalDuration);
        } else {
            this.unhandled(o);
        }
    }

    public List<Message> fetchMessagesFromTheQueue(String url) {
        logger.info("fetchMessagesFromTheQueue() : " + url);
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(url);
        receiveMessageRequest.setMaxNumberOfMessages(Integer.valueOf(10));
        List messages = this.sqs.receiveMessage(receiveMessageRequest).getMessages();
        return messages;
    }

    public static Props props(final String urlQueue, final Region regionInsideAWS, final ActorRef whoIsTheFather) {
        return new Props(new UntypedActorFactory(){

            public Actor create() throws Exception {
                return new FetchFromQueueActor(urlQueue, regionInsideAWS, whoIsTheFather);
            }
        });
    }

    public void preStart() {
        logger.debug("preStart() : initialize AWS Client");
        this.sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
        this.sqs.setRegion(this.region);
    }

    public static class StopFetching {
        public final long startTime;
        public final long numberOfMessages;
        public final long stopTime;

        public StopFetching(long startTime, long numberOfMessages) {
            this.startTime = startTime;
            this.numberOfMessages = numberOfMessages;
            this.stopTime = System.currentTimeMillis();
        }

        public String toString() {
            return "StopFetching{startTime=" + this.startTime + ", numberOfMessages=" + this.numberOfMessages + ", stopTime=" + this.stopTime + '}';
        }
    }

    public static class StartFetching {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FetchedMessageBucket {
        public final List<Message> messages = new ArrayList<Message>();

        public FetchedMessageBucket(List<Message> messages) {
            this.messages.addAll(messages);
        }
    }
}

