/*
 * Decompiled with CFR 0.152.
 */
package audit;

import akka.actor.UntypedActor;
import audit.messages.ErrorMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorMessageReceiverDatabaseActor
extends UntypedActor {
    public static final String ACTOR_NAME = "error-message-receiver-database-actor";
    private static final Logger logger = LoggerFactory.getLogger(ErrorMessageReceiverDatabaseActor.class);
    private static final String insertString = "INSERT INTO audit_errors (reason, message, event_when, account_id, aws_date_time) VALUES (?, ?, ?, ?, (select now()))";
    private Connection connection = null;
    private DataSource dataSource = null;

    public ErrorMessageReceiverDatabaseActor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof ErrorMessage) {
            logger.info("Received ErrorMessage message: {}", message);
            ErrorMessage errorMessage = (ErrorMessage)message;
            PreparedStatement statement = this.connection.prepareStatement(insertString);
            statement.setString(1, errorMessage.getReason().getMessage());
            statement.setString(2, errorMessage.getMessage().toString());
            String when = errorMessage.getWhen().toLocalDate().toString();
            statement.setString(3, when);
            String accountId = errorMessage.getAccountId();
            statement.setString(4, accountId);
            statement.executeUpdate();
        } else {
            this.unhandled(message);
        }
    }

    public void initializeDBConnection() {
        logger.info("initializeDBConnection() : initialize connection to DB");
        try {
            this.connection = this.dataSource.getConnection();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            logger.error("Error initialize DB", (Throwable)e);
        }
    }

    public void closeDbConnection() {
        logger.info("closeDbConnection() : close DB connection");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            logger.error("Error close DB connection", (Throwable)e);
        }
    }

    public void preStart() {
        logger.info("preStart()");
        this.initializeDBConnection();
    }

    public void postStop() {
        logger.info("postStop()");
        this.closeDbConnection();
    }

    public void preRestart(Throwable reason, Option<Object> message) {
        logger.info("preRestart()");
        this.closeDbConnection();
    }

    public void postRestart(Throwable reason) {
        logger.info("postRestart()");
        this.initializeDBConnection();
    }
}

