/*
 * Decompiled with CFR 0.152.
 */
package jmonitor;

import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMonitorData
implements Comparable<JMonitorData> {
    public String label;
    public long hits;
    public double avg;
    public double total;
    public double stddev;
    public double lastvalue;
    public double min;
    public double max;
    public long active;
    public double avgactive;
    public long maxactive;
    public long firstaccess;
    public long lastaccess;

    public JMonitorData() {
    }

    public JMonitorData(Object[] data) {
        int i = 0;
        this.label = (String)data[i++];
        this.hits = ((Number)data[i++]).longValue();
        this.avg = ((Number)data[i++]).doubleValue();
        this.total = ((Number)data[i++]).doubleValue();
        this.stddev = ((Number)data[i++]).doubleValue();
        this.lastvalue = ((Number)data[i++]).doubleValue();
        this.min = ((Number)data[i++]).doubleValue();
        this.max = ((Number)data[i++]).doubleValue();
        this.active = ((Number)data[i++]).longValue();
        this.avgactive = ((Number)data[i++]).doubleValue();
        this.maxactive = ((Number)data[i++]).longValue();
        this.firstaccess = data[i++] instanceof Date ? ((Date)data[i - 1]).getTime() : ((Number)data[i - 1]).longValue();
        this.lastaccess = data[i++] instanceof Date ? ((Date)data[i - 1]).getTime() : ((Number)data[i - 1]).longValue();
    }

    public static JMonitorData combine(JMonitorData data1, JMonitorData data2) {
        JMonitorData result = new JMonitorData();
        result.label = data1.label;
        result.hits = data1.hits + data2.hits;
        result.total = data1.total + data2.total;
        result.avg = result.total / (double)result.hits;
        result.stddev = Math.sqrt(((double)data1.hits * (Math.pow(data1.stddev, 2.0) + Math.pow(data1.avg - result.avg, 2.0)) + (double)data2.hits * (Math.pow(data2.stddev, 2.0) + Math.pow(data2.avg - result.avg, 2.0))) / (double)result.hits);
        result.lastvalue = data1.lastaccess > data2.lastaccess ? data1.lastvalue : data2.lastvalue;
        result.min = Math.min(data1.min, data2.min);
        result.max = Math.max(data1.max, data2.max);
        result.active = data1.active + data2.active;
        result.avgactive = (data1.avgactive * (double)data1.hits + data2.avgactive * (double)data2.hits) / (double)result.hits;
        result.maxactive = Math.max(data1.maxactive, data2.maxactive);
        result.firstaccess = data1.firstaccess < data2.firstaccess ? data1.firstaccess : data2.firstaccess;
        result.lastaccess = data1.lastaccess > data2.lastaccess ? data1.lastaccess : data2.lastaccess;
        return result;
    }

    @Override
    public int compareTo(JMonitorData o) {
        return this.label.compareTo(o.label);
    }
}

