/*
 * Decompiled with CFR 0.152.
 */
package aws.sqs;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import aws.sqs.DeleteFromQueueMaster;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFromQueueActor
extends UntypedActor {
    public static final String ACTOR_NAME = "delete-from-queue-actor";
    private static final Logger logger = LoggerFactory.getLogger(DeleteFromQueueActor.class);
    private final String queueUrl;
    private final Region region;
    private final ActorRef father;
    private AmazonSQS sqs;

    private DeleteFromQueueActor(String queueUrl, Region region, ActorRef father) {
        this.queueUrl = queueUrl;
        this.region = region;
        this.father = father;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof MessageDropBucket) {
            logger.info("onReceive() : receive MessageDropBucket bucket");
            MessageDropBucket messageBucket = (MessageDropBucket)message;
            ArrayList<DeleteMessageBatchRequestEntry> entryList = new ArrayList<DeleteMessageBatchRequestEntry>();
            for (Map<String, String> eachMessageMap : messageBucket.messages) {
                DeleteMessageBatchRequestEntry entry = new DeleteMessageBatchRequestEntry(UUID.randomUUID().toString(), eachMessageMap.get("receiptHandle"));
                entryList.add(entry);
                if (entryList.size() != 10) continue;
                DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(this.queueUrl, entryList);
                this.sqs.deleteMessageBatch(deleteMessageBatchRequest);
                entryList.clear();
            }
            if (!entryList.isEmpty()) {
                DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(this.queueUrl, entryList);
                this.sqs.deleteMessageBatch(deleteMessageBatchRequest);
            }
            logger.info("onReceive() : delete message bucket back like successful message");
            this.getSender().tell((Object)messageBucket, this.getSelf());
        } else {
            this.unhandled(message);
        }
    }

    public static Props props(final String urlQueue, final Region regionInsideAWS, final ActorRef whoIsTheFather) {
        return new Props(new UntypedActorFactory(){

            public Actor create() throws Exception {
                return new DeleteFromQueueActor(urlQueue, regionInsideAWS, whoIsTheFather);
            }
        });
    }

    public void preStart() {
        logger.debug("preStart() : initialize AWS Client");
        this.sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
        this.sqs.setRegion(this.region);
    }

    public void preRestart(Throwable reason, Option<Object> message) {
        if (reason instanceof AmazonServiceException && message.isDefined()) {
            logger.info("preRestart() : " + reason + " put message back into mailbox");
            MessageDropBucket bucket = (MessageDropBucket)message.get();
            DeleteFromQueueMaster.TryDeleteAgainMessageBucket tryAgainMessageBucket = new DeleteFromQueueMaster.TryDeleteAgainMessageBucket(bucket);
            this.father.tell((Object)tryAgainMessageBucket, this.getSelf());
            this.getSelf().tell((Object)bucket, this.father);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageDropBucket {
        public final String queueName;
        public final String bucketId;
        public final List<Map<String, String>> messages;

        public MessageDropBucket(List<Map<String, String>> messages, String queueName) {
            this.bucketId = UUID.randomUUID().toString();
            this.messages = new ArrayList<Map<String, String>>();
            for (Map<String, String> eachMap : messages) {
                HashMap<String, String> tmpMap = new HashMap<String, String>(eachMap);
                this.messages.add(tmpMap);
            }
            this.queueName = queueName;
        }

        public MessageDropBucket(MessageDropBucket origin) {
            this.bucketId = origin.bucketId;
            this.messages = new ArrayList<Map<String, String>>();
            for (Map<String, String> eachMap : origin.messages) {
                HashMap<String, String> tmpMap = new HashMap<String, String>(eachMap);
                this.messages.add(tmpMap);
            }
            this.queueName = origin.queueName;
        }

        public String toString() {
            StringBuilder messagesStringBuilder = new StringBuilder("[");
            for (Map<String, String> eachMap : this.messages) {
                messagesStringBuilder.append("[receip=");
                messagesStringBuilder.append(eachMap.get("receiptHandle"));
                messagesStringBuilder.append(",body=");
                messagesStringBuilder.append(eachMap.get("body"));
                messagesStringBuilder.append("],");
            }
            messagesStringBuilder.append("]");
            return "MessageDropBucket{bucketId='" + this.bucketId + '\'' + ", messages=" + messagesStringBuilder.toString() + '}';
        }
    }
}

