/*
 * Decompiled with CFR 0.152.
 */
package aws.sqs;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import aws.sqs.DeleteFromQueueMaster;
import aws.sqs.FetchFromQueueMaster;
import aws.sqs.PutIntoQueueMaster;
import com.amazonaws.services.sqs.model.Message;
import exceptions.ServiceException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqsManager {
    private static final Logger logger = LoggerFactory.getLogger(SqsManager.class);
    private static ActorSystem system;
    private static String sourceQueuName;
    private static String tempQueueName;
    private static String regionName;
    private static int howManyWorkersForFetch;
    private static int howManyWorkersForPut;
    private static int howManyWorkersForDelete;

    public static ActorSystem getActorSystem() {
        SqsManager.isInitialized();
        return system;
    }

    public static void initializeWithTempQueue(ActorSystem actorSystem, String queueName, String queueTmpName, String nameRegion, int howManyWorkersForFetchParam, int howManyWorkersForPutParam, int howManyWorkersForDeleteParam) {
        if (actorSystem == null) {
            throw new ServiceException("actorSystem is null", null);
        }
        if (system == null) {
            logger.info("SqsManager : initialize with actor system");
            system = actorSystem;
            sourceQueuName = queueName;
            tempQueueName = queueTmpName;
            regionName = nameRegion;
            howManyWorkersForFetch = howManyWorkersForFetchParam;
            howManyWorkersForPut = howManyWorkersForPutParam;
            howManyWorkersForDelete = howManyWorkersForDeleteParam;
        } else {
            logger.info("SqsManager : already initialized");
        }
    }

    public static void initializeOnlyForStoringIds(ActorSystem actorSystem, String queueName, String regionName, int howManyWorkersForPut) {
        if (actorSystem == null) {
            throw new ServiceException("actorSystem is null", null);
        }
        if (system == null) {
            logger.info("SqsManager : initialize with actor system");
            system = actorSystem;
            ActorRef putMessageIntoQueueActor = system.actorOf(PutIntoQueueMaster.props(queueName, regionName, howManyWorkersForPut, system.actorOf(new Props(DefaultResultReceiver.class), "default-receiver")), "put-into-queue-master");
        } else {
            logger.info("SqsManager : already initialized");
        }
    }

    public static void transferDnaIdsFromQueueToTempQueue(ActorRef whoAreInterestedInFinalResult, ActorRef whoAreInterestedInTempResult) {
        SqsManager.isInitializedWithTempQueue();
        ActorRef mainBroker = system.actorOf(MainBroker.props(whoAreInterestedInFinalResult, whoAreInterestedInTempResult, sourceQueuName, tempQueueName), "main-broker-actor" + UUID.randomUUID().toString());
        mainBroker.tell((Object)"Start", null);
    }

    public static void transferDnaIdsFromTempQueueBack(ActorRef whoAreInterested) {
        SqsManager.isInitializedWithTempQueue();
        ActorRef mainBroker = system.actorOf(MainBroker.props(whoAreInterested, null, tempQueueName, sourceQueuName), "main-broker-actor" + UUID.randomUUID().toString());
        mainBroker.tell((Object)"Start", null);
    }

    public static void putDnaAccountIdIntoQueue(String id) {
        SqsManager.isInitialized();
        ActorRef putMessageIntoQueueActor = system.actorFor("/user/put-into-queue-master");
        ArrayList<List<String>> iterableMessageLists = new ArrayList<List<String>>();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        iterableMessageLists.add(idList);
        PutIntoQueueMaster.PutTheseMessages putTheseMessages = new PutIntoQueueMaster.PutTheseMessages(iterableMessageLists);
        putMessageIntoQueueActor.tell((Object)putTheseMessages, null);
    }

    public static void putDnaAccountIdIntoQueue(Iterable<List<String>> ids) {
        SqsManager.isInitialized();
        ActorRef putMessageIntoQueueActor = system.actorFor("/user/put-into-queue-master");
        PutIntoQueueMaster.PutTheseMessages putTheseMessages = new PutIntoQueueMaster.PutTheseMessages(ids);
        putMessageIntoQueueActor.tell((Object)putTheseMessages, null);
    }

    private static void isInitialized() {
        if (system == null) {
            throw new ServiceException("SqsManager has not been initialized correctly", null);
        }
    }

    private static void isInitializedWithTempQueue() {
        if (system == null || sourceQueuName == null || sourceQueuName.isEmpty() || tempQueueName == null || tempQueueName.isEmpty() || howManyWorkersForDelete == 0 || howManyWorkersForFetch == 0 || howManyWorkersForPut == 0) {
            throw new ServiceException("SqsManager has not been initialized correctly", null);
        }
    }

    public static class MainBroker
    extends UntypedActor {
        private static final Logger logger = LoggerFactory.getLogger(MainBroker.class);
        public static final String ACTOR_NAME = "main-broker-actor";
        private ActorRef fetchActor;
        private ActorRef deleteActor;
        private ActorRef putActor;
        private ActorRef whoAreInterestedInFinalResult;
        private ActorRef whoAreInterestedInTempResult;
        private String queueName;
        private String tmpQueueName;

        private MainBroker(ActorRef whoAreInterestedInFinalResult, ActorRef whoAreInterestedInTempResult, String queueName, String tempQueueName) {
            this.whoAreInterestedInFinalResult = whoAreInterestedInFinalResult;
            this.queueName = queueName;
            this.tmpQueueName = tempQueueName;
        }

        public static Props props(final ActorRef whoAreInterestedInFinalResult, final ActorRef whoAreInterestedInTmpResult, final String queueName, final String tempQueueName) {
            return new Props(new UntypedActorFactory(){

                public Actor create() throws Exception {
                    return new MainBroker(whoAreInterestedInFinalResult, whoAreInterestedInTmpResult, queueName, tempQueueName);
                }
            });
        }

        public void onReceive(Object o) throws Exception {
            if (o.equals("Start")) {
                this.fetchActor.tell((Object)new FetchFromQueueMaster.StartFetchingMessage(), null);
            } else if (o instanceof FetchFromQueueMaster.FetchFromQueueTempReport) {
                logger.info("onReceive() : receive FetchFromQueueTempReport");
                FetchFromQueueMaster.FetchFromQueueTempReport tempReport = (FetchFromQueueMaster.FetchFromQueueTempReport)o;
                List<Message> messages = tempReport.messages;
                if (this.whoAreInterestedInTempResult != null) {
                    ArrayList<String> bodyList = new ArrayList<String>();
                    for (Message eachMessage : messages) {
                        bodyList.add(eachMessage.getBody());
                    }
                    this.whoAreInterestedInTempResult.tell(bodyList, this.getSelf());
                }
                PutIntoQueueMaster.PutTheseAWSMessages putTheseAWSMessages = new PutIntoQueueMaster.PutTheseAWSMessages(messages);
                this.putActor.tell((Object)putTheseAWSMessages, null);
            } else if (o instanceof PutIntoQueueMaster.PutIntoQueueTempReport) {
                logger.info("onReceive() : receive PutIntoQueueTempReport");
                PutIntoQueueMaster.PutIntoQueueTempReport putIntoQueueTempReport = (PutIntoQueueMaster.PutIntoQueueTempReport)o;
                List<Map<String, String>> successfulySended = putIntoQueueTempReport.wasSuccessfulSended.messages;
                DeleteFromQueueMaster.DeleteTheseMessages deleteTheseMessages = new DeleteFromQueueMaster.DeleteTheseMessages(successfulySended);
                this.deleteActor.tell((Object)deleteTheseMessages, null);
            } else if (o instanceof PutIntoQueueMaster.PutIntoQueueReport) {
                logger.info("onReceive() : receive PutIntoQueueReport");
                this.whoAreInterestedInFinalResult.tell(o, this.getSelf());
                this.getContext().stop(this.putActor);
            } else if (o instanceof FetchFromQueueMaster.FetchFromQueueReport) {
                logger.info("onReceive() : receive FetchFromQueueReport");
                this.whoAreInterestedInFinalResult.tell(o, this.getSelf());
                this.getContext().stop(this.fetchActor);
            } else if (o instanceof DeleteFromQueueMaster.DeleteFromQueueReport) {
                logger.info("onReceive() : receive DeleteFromQueueReport");
                this.whoAreInterestedInFinalResult.tell(o, this.getSelf());
                this.getContext().stop(this.deleteActor);
            } else {
                this.unhandled(o);
            }
        }

        public void preStart() {
            this.fetchActor = this.getContext().actorOf(FetchFromQueueMaster.props(this.queueName, regionName, howManyWorkersForFetch, this.getSelf()));
            this.deleteActor = this.getContext().actorOf(DeleteFromQueueMaster.props(this.queueName, regionName, howManyWorkersForDelete, this.getSelf()));
            this.putActor = this.getContext().actorOf(PutIntoQueueMaster.props(this.tmpQueueName, regionName, howManyWorkersForPut, this.getSelf()));
        }
    }

    public static class DefaultResultReceiver
    extends UntypedActor {
        private static final Logger dfLogger = LoggerFactory.getLogger(DefaultResultReceiver.class);

        public void onReceive(Object o) throws Exception {
            if (o instanceof PutIntoQueueMaster.PutIntoQueueReport) {
                dfLogger.info("Just put id into queue");
            } else {
                this.unhandled(o);
            }
        }
    }
}

