/*
 * Decompiled with CFR 0.152.
 */
package aws.sqs;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.DeadLetter;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.japi.Function;
import akka.routing.RoundRobinRouter;
import akka.routing.RouterConfig;
import aws.sqs.PutIntoQueueActor;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.concurrent.duration.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutIntoQueueMaster
extends UntypedActor {
    public static final String ACTOR_NAME = "put-into-queue-master";
    private static final String PUT_ROUTER_NAME = "put-messages-router";
    private static final Logger logger = LoggerFactory.getLogger(PutIntoQueueMaster.class);
    private final String queueName;
    private final Region region;
    private final int numberOfChilds;
    private ActorRef router;
    private ActorRef whoAreInterestedInResult;
    private Set<String> sendedBucketIds = new HashSet<String>();
    private long startTime = -1L;
    private long successfulSendedAmount = 0L;
    private Map<String, Integer> sendedMessageMap = new HashMap<String, Integer>();
    private Map<String, PutIntoQueueActor.MessageBucket> tryAgainMessageBucketMap = new HashMap<String, PutIntoQueueActor.MessageBucket>();
    private static final int HOW_LONG_WAIT_NEXT_MESSAGE_BEFORE_FINISH_IN_MIN = 5;
    private static SupervisorStrategy supervisorStrategyForRouter = new OneForOneStrategy(15, (Duration)Duration.create((long)1L, (TimeUnit)TimeUnit.MINUTES), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

        public SupervisorStrategy.Directive apply(Throwable t) {
            if (t instanceof Exception) {
                return SupervisorStrategy.restart();
            }
            return SupervisorStrategy.escalate();
        }
    });

    private PutIntoQueueMaster(String nameQueue, String regionName, int numberOfChilds, ActorRef whoAreWaitingResult) {
        this.queueName = nameQueue;
        this.region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
        this.numberOfChilds = numberOfChilds;
        this.whoAreInterestedInResult = whoAreWaitingResult;
    }

    public static Props props(final String nameQueue, final String nameRegion, final int howManyWorkers, final ActorRef whoAreWaitingResult) {
        if (nameQueue == null || nameQueue.isEmpty() || howManyWorkers <= 0 || nameRegion == null || nameRegion.isEmpty() || whoAreWaitingResult == null) {
            throw new IllegalArgumentException("Could not initialize master with nameQueue : " + nameQueue + " inside region : " + nameRegion + " and howManyWorkers : " + howManyWorkers);
        }
        return new Props(new UntypedActorFactory(){

            public Actor create() throws Exception {
                return new PutIntoQueueMaster(nameQueue, nameRegion, howManyWorkers, whoAreWaitingResult);
            }
        });
    }

    public void preStart() {
        logger.debug("preStart() : Initialize Amazon SQS");
        AmazonSQSClient sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
        sqs.setRegion(this.region);
        String queueUrl = null;
        for (String eachUrl : sqs.listQueues().getQueueUrls()) {
            if (!eachUrl.endsWith(this.queueName)) continue;
            queueUrl = eachUrl;
            logger.debug("preStart() : Found queue with url : " + queueUrl);
            break;
        }
        if (queueUrl == null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("VisibilityTimeout", "1800");
            CreateQueueRequest createQueueRequest = new CreateQueueRequest(this.queueName);
            createQueueRequest = createQueueRequest.withAttributes(attributes);
            queueUrl = sqs.createQueue(createQueueRequest).getQueueUrl();
            logger.debug("preStart() : \u0421reate new queue with url : " + queueUrl);
        }
        logger.debug("preStart() : initialize router with workers : subscribe to dead letters");
        this.router = this.getContext().actorOf(PutIntoQueueActor.props(queueUrl, this.region, this.getSelf()).withRouter((RouterConfig)new RoundRobinRouter(this.numberOfChilds).withSupervisorStrategy(supervisorStrategyForRouter)), PUT_ROUTER_NAME);
        this.getContext().system().eventStream().subscribe(this.getSelf(), DeadLetter.class);
    }

    public void preRestart(Throwable reason, Option<Object> message) {
    }

    public void postRestart(Throwable reason) {
        logger.info("postRestart() : fetch router with workers from context");
        this.router = this.getContext().getChild(PUT_ROUTER_NAME);
        this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof PutTheseMessages) {
            logger.info("onReceive() : receive PutTheseMessages : start send buckets to workers");
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
            }
            PutTheseMessages putTheseMessages = (PutTheseMessages)message;
            for (List<String> eachList : putTheseMessages.iterableMessageLists) {
                ArrayList<Map<String, String>> butchMessages = new ArrayList<Map<String, String>>();
                for (String eachString : eachList) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    tmpMap.put("body", eachString);
                    butchMessages.add(tmpMap);
                    if (butchMessages.size() != 10) continue;
                    PutIntoQueueActor.MessageBucket messageBucket = new PutIntoQueueActor.MessageBucket(butchMessages, this.queueName);
                    this.router.tell((Object)messageBucket, this.getSelf());
                    this.sendedBucketIds.add(messageBucket.bucketId);
                    this.sendedMessageMap.put(messageBucket.bucketId, messageBucket.messages.size());
                    butchMessages.clear();
                }
                if (butchMessages.isEmpty()) continue;
                PutIntoQueueActor.MessageBucket messageBucket = new PutIntoQueueActor.MessageBucket(butchMessages, this.queueName);
                this.router.tell((Object)messageBucket, this.getSelf());
                this.sendedBucketIds.add(messageBucket.bucketId);
                this.sendedMessageMap.put(messageBucket.bucketId, messageBucket.messages.size());
            }
            logger.info("onReceive() : finish sending messages to workers : amount : " + this.sendedBucketIds.size());
        } else if (message instanceof PutTheseAWSMessages) {
            logger.info("onReceive() : receive PutTheseAWSMessages : start send buckets to workers");
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
            }
            PutTheseAWSMessages putTheseAWSMessages = (PutTheseAWSMessages)message;
            ArrayList<Map<String, String>> butchMessages = new ArrayList<Map<String, String>>();
            for (Message eachAwsMessage : putTheseAWSMessages.awsMessageList) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("body", eachAwsMessage.getBody());
                tmpMap.put("receiptHandle", eachAwsMessage.getReceiptHandle());
                butchMessages.add(tmpMap);
                if (butchMessages.size() != 10) continue;
                PutIntoQueueActor.MessageBucket messageBucket = new PutIntoQueueActor.MessageBucket(butchMessages, this.queueName);
                this.router.tell((Object)messageBucket, this.getSelf());
                this.sendedBucketIds.add(messageBucket.bucketId);
                this.sendedMessageMap.put(messageBucket.bucketId, messageBucket.messages.size());
                butchMessages.clear();
            }
            if (!butchMessages.isEmpty()) {
                PutIntoQueueActor.MessageBucket messageBucket = new PutIntoQueueActor.MessageBucket(butchMessages, this.queueName);
                this.router.tell((Object)messageBucket, this.getSelf());
                this.sendedBucketIds.add(messageBucket.bucketId);
                this.sendedMessageMap.put(messageBucket.bucketId, messageBucket.messages.size());
            }
            logger.info("onReceive() : finish sending AWS messages to workers : amount : " + this.sendedBucketIds.size());
        } else if (message instanceof TryAgainMessageBucket) {
            logger.info("onReceive() : receive try again message bucket");
            TryAgainMessageBucket tryAgainMessageBucket = (TryAgainMessageBucket)message;
            this.tryAgainMessageBucketMap.put(tryAgainMessageBucket.messageBucket.bucketId, tryAgainMessageBucket.messageBucket);
            this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
        } else if (message instanceof DeadLetter) {
            DeadLetter deadLetter = (DeadLetter)message;
            Object originalMessage = deadLetter.message();
            if (originalMessage instanceof PutIntoQueueActor.MessageBucket) {
                PutIntoQueueActor.MessageBucket putMessage = (PutIntoQueueActor.MessageBucket)originalMessage;
                if (putMessage.queueName.equals(this.queueName)) {
                    logger.info("onReceive() : receive DeadLetter message bucket");
                    this.tryAgainMessageBucketMap.put(putMessage.bucketId, putMessage);
                    this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
                }
            }
        } else if (message instanceof PutIntoQueueActor.MessageBucket) {
            logger.info("onReceive() : receive successful sended message bucket");
            PutIntoQueueActor.MessageBucket successfulSendedBucket = (PutIntoQueueActor.MessageBucket)message;
            this.sendedBucketIds.remove(successfulSendedBucket.bucketId);
            this.successfulSendedAmount += (long)successfulSendedBucket.messages.size();
            this.sendedMessageMap.remove(successfulSendedBucket.bucketId);
            this.tryAgainMessageBucketMap.remove(successfulSendedBucket.bucketId);
            if (this.whoAreInterestedInResult != null) {
                PutIntoQueueTempReport tempReport = new PutIntoQueueTempReport(successfulSendedBucket);
                this.whoAreInterestedInResult.tell((Object)tempReport, this.getSelf());
            }
            this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
        } else if (message == ReceiveTimeout.getInstance()) {
            this.sendReportAndStopTimeout();
        } else {
            this.unhandled(message);
        }
    }

    private void sendReportAndStopTimeout() {
        logger.info("sendReportAndStopTimeout()");
        int amountOfDeadMessage = 0;
        for (String eachKey : this.sendedBucketIds) {
            Integer amount = this.sendedMessageMap.get(eachKey);
            if (amount == null) continue;
            amountOfDeadMessage += amount.intValue();
        }
        if (this.whoAreInterestedInResult != null) {
            PutIntoQueueReport putIntoQueueReport = new PutIntoQueueReport(this.startTime, System.currentTimeMillis(), amountOfDeadMessage, this.successfulSendedAmount, this.tryAgainMessageBucketMap);
            this.whoAreInterestedInResult.tell((Object)putIntoQueueReport, this.getSelf());
        }
        this.clearInnerState();
        this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
    }

    private void clearInnerState() {
        logger.info("clearInnerState()");
        this.sendedBucketIds.clear();
        this.startTime = -1L;
        this.successfulSendedAmount = 0L;
        this.whoAreInterestedInResult = null;
        this.sendedMessageMap.clear();
        this.tryAgainMessageBucketMap.clear();
    }

    public static class PutIntoQueueTempReport {
        public final PutIntoQueueActor.MessageBucket wasSuccessfulSended;

        public PutIntoQueueTempReport(PutIntoQueueActor.MessageBucket wasSuccessfulSended) {
            this.wasSuccessfulSended = new PutIntoQueueActor.MessageBucket(wasSuccessfulSended);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutIntoQueueReport {
        public final long startTime;
        public final long finishTime;
        public final int amountOfDeadMessages;
        public final long successfulSendedAmount;
        public final Map<String, PutIntoQueueActor.MessageBucket> tryAgainMessageBucket;

        public PutIntoQueueReport(long startTime, long finishTime, int amountOfDeadMessages, long successfulSendedAmount, Map<String, PutIntoQueueActor.MessageBucket> tryAgainMessageBucket) {
            this.startTime = startTime;
            this.finishTime = finishTime;
            this.amountOfDeadMessages = amountOfDeadMessages;
            this.successfulSendedAmount = successfulSendedAmount;
            this.tryAgainMessageBucket = new HashMap<String, PutIntoQueueActor.MessageBucket>();
            for (String eachKey : tryAgainMessageBucket.keySet()) {
                PutIntoQueueActor.MessageBucket originalBucket = tryAgainMessageBucket.get(eachKey);
                if (originalBucket == null) continue;
                PutIntoQueueActor.MessageBucket newBucket = new PutIntoQueueActor.MessageBucket(originalBucket);
                this.tryAgainMessageBucket.put(eachKey, newBucket);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (PutIntoQueueActor.MessageBucket eachValue : this.tryAgainMessageBucket.values()) {
                stringBuilder.append(eachValue.toString());
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            return "PutIntoQueueReport{time =" + (this.finishTime - this.startTime) + ", deadMessages.size()=" + this.amountOfDeadMessages + ", successfulSendedAmount=" + this.successfulSendedAmount + ", notSendetMessages=" + stringBuilder.toString() + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutTheseAWSMessages {
        public final List<Message> awsMessageList = new ArrayList<Message>();

        public PutTheseAWSMessages(List<Message> awsMessageList) {
            this.awsMessageList.addAll(awsMessageList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutTheseMessages {
        public final List<List<String>> iterableMessageLists = new ArrayList<List<String>>();

        public PutTheseMessages(Iterable<List<String>> iterableMessageLists) {
            for (List<String> eachList : iterableMessageLists) {
                ArrayList<String> tmpList = new ArrayList<String>();
                tmpList.addAll(eachList);
                this.iterableMessageLists.add(tmpList);
            }
        }
    }

    public static class TryAgainMessageBucket {
        public final PutIntoQueueActor.MessageBucket messageBucket;

        public TryAgainMessageBucket(PutIntoQueueActor.MessageBucket messageBucket) {
            this.messageBucket = new PutIntoQueueActor.MessageBucket(messageBucket);
        }
    }
}

