/*
 * Decompiled with CFR 0.152.
 */
package aws.sqs;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.DeadLetter;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.japi.Function;
import akka.routing.RoundRobinRouter;
import akka.routing.RouterConfig;
import aws.sqs.DeleteFromQueueActor;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.concurrent.duration.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFromQueueMaster
extends UntypedActor {
    public static final String ACTOR_NAME = "delete-from-queue-master";
    private static final String DELETE_ROUTER_NAME = "delete-messages-router";
    private static final Logger logger = LoggerFactory.getLogger(DeleteFromQueueMaster.class);
    private final String queueName;
    private final Region region;
    private final int numberOfChilds;
    private ActorRef router;
    private ActorRef whoAreInterestedInResult;
    private Set<String> sendedToDeletedBucketIds = new HashSet<String>();
    private long startTime = -1L;
    private long successfulDeletedAmount = 0L;
    private Map<String, Integer> sendedToDeleteMessageMap = new HashMap<String, Integer>();
    private Map<String, DeleteFromQueueActor.MessageDropBucket> tryAgainMessageBucketMap = new HashMap<String, DeleteFromQueueActor.MessageDropBucket>();
    private static final int HOW_LONG_WAIT_NEXT_MESSAGE_BEFORE_FINISH_IN_MIN = 5;
    private static SupervisorStrategy supervisorStrategyForRouter = new OneForOneStrategy(15, (Duration)Duration.create((long)1L, (TimeUnit)TimeUnit.MINUTES), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

        public SupervisorStrategy.Directive apply(Throwable t) {
            if (t instanceof Exception) {
                return SupervisorStrategy.restart();
            }
            return SupervisorStrategy.escalate();
        }
    });

    private DeleteFromQueueMaster(String nameQueue, String regionName, int numberOfChilds, ActorRef whoAreWaitingResult) {
        this.queueName = nameQueue;
        this.region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
        this.numberOfChilds = numberOfChilds;
        this.whoAreInterestedInResult = whoAreWaitingResult;
    }

    public static Props props(final String nameQueue, final String nameRegion, final int howManyWorkers, final ActorRef whoAreWaitingResult) {
        if (nameQueue == null || nameQueue.isEmpty() || howManyWorkers <= 0 || nameRegion == null || nameRegion.isEmpty() || whoAreWaitingResult == null) {
            throw new IllegalArgumentException("Could not initialize master with nameQueue : " + nameQueue + " inside region : " + nameRegion + " and howManyWorkers : " + howManyWorkers);
        }
        return new Props(new UntypedActorFactory(){

            public Actor create() throws Exception {
                return new DeleteFromQueueMaster(nameQueue, nameRegion, howManyWorkers, whoAreWaitingResult);
            }
        });
    }

    public void preStart() {
        logger.debug("preStart() : Initialize Amazon SQS");
        AmazonSQSClient sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
        sqs.setRegion(this.region);
        String queueUrl = null;
        for (String eachUrl : sqs.listQueues().getQueueUrls()) {
            if (!eachUrl.endsWith(this.queueName)) continue;
            queueUrl = eachUrl;
            logger.debug("preStart() : Found queue with url : " + queueUrl);
            break;
        }
        if (queueUrl == null) {
            CreateQueueRequest createQueueRequest = new CreateQueueRequest(this.queueName);
            queueUrl = sqs.createQueue(createQueueRequest).getQueueUrl();
            logger.debug("preStart() : \u0421reate new queue with url : " + queueUrl);
        }
        logger.debug("preStart() : initialize router with workers : subscribe to dead letters");
        this.router = this.getContext().actorOf(DeleteFromQueueActor.props(queueUrl, this.region, this.getSelf()).withRouter((RouterConfig)new RoundRobinRouter(this.numberOfChilds).withSupervisorStrategy(supervisorStrategyForRouter)), DELETE_ROUTER_NAME);
        this.getContext().system().eventStream().subscribe(this.getSelf(), DeadLetter.class);
    }

    public void preRestart(Throwable reason, Option<Object> message) {
    }

    public void postRestart(Throwable reason) {
        logger.info("postRestart() : fetch router with workers from context");
        this.router = this.getContext().getChild(DELETE_ROUTER_NAME);
        this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof DeleteTheseMessages) {
            logger.info("onReceive() : receive DeleteTheseMessages : start send buckets to workers");
            if (this.startTime == -1L) {
                this.startTime = System.currentTimeMillis();
            }
            DeleteTheseMessages deleteTheseMessages = (DeleteTheseMessages)message;
            ArrayList<Map<String, String>> butchMessages = new ArrayList<Map<String, String>>();
            for (Map<String, String> eachMessage : deleteTheseMessages.messageList) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("body", eachMessage.get("body"));
                tmpMap.put("receiptHandle", eachMessage.get("receiptHandle"));
                butchMessages.add(tmpMap);
                if (butchMessages.size() != 10) continue;
                DeleteFromQueueActor.MessageDropBucket deleteMessageBucket = new DeleteFromQueueActor.MessageDropBucket(butchMessages, this.queueName);
                this.router.tell((Object)deleteMessageBucket, this.getSelf());
                this.sendedToDeletedBucketIds.add(deleteMessageBucket.bucketId);
                this.sendedToDeleteMessageMap.put(deleteMessageBucket.bucketId, deleteMessageBucket.messages.size());
                butchMessages.clear();
            }
            if (!butchMessages.isEmpty()) {
                DeleteFromQueueActor.MessageDropBucket deleteMessageBucket = new DeleteFromQueueActor.MessageDropBucket(butchMessages, this.queueName);
                this.router.tell((Object)deleteMessageBucket, this.getSelf());
                this.sendedToDeletedBucketIds.add(deleteMessageBucket.bucketId);
                this.sendedToDeleteMessageMap.put(deleteMessageBucket.bucketId, deleteMessageBucket.messages.size());
            }
            logger.info("onReceive() : finish sending AWS delete messages to workers : amount : " + this.sendedToDeletedBucketIds.size());
        } else if (message instanceof DeleteTheseAWSMessages) {
            logger.info("onReceive() : receive DeleteTheseAWSMessages : start send buckets to workers");
            if (this.startTime != -1L) {
                this.startTime = System.currentTimeMillis();
            }
            DeleteTheseAWSMessages deleteTheseAWSMessages = (DeleteTheseAWSMessages)message;
            ArrayList<Map<String, String>> butchMessages = new ArrayList<Map<String, String>>();
            for (Message eachAwsMessage : deleteTheseAWSMessages.awsMessageList) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("body", eachAwsMessage.getBody());
                tmpMap.put("receiptHandle", eachAwsMessage.getReceiptHandle());
                butchMessages.add(tmpMap);
                if (butchMessages.size() != 10) continue;
                DeleteFromQueueActor.MessageDropBucket deleteMessageBucket = new DeleteFromQueueActor.MessageDropBucket(butchMessages, this.queueName);
                this.router.tell((Object)deleteMessageBucket, this.getSelf());
                this.sendedToDeletedBucketIds.add(deleteMessageBucket.bucketId);
                this.sendedToDeleteMessageMap.put(deleteMessageBucket.bucketId, deleteMessageBucket.messages.size());
                butchMessages.clear();
            }
            if (!butchMessages.isEmpty()) {
                DeleteFromQueueActor.MessageDropBucket deleteMessageBucket = new DeleteFromQueueActor.MessageDropBucket(butchMessages, this.queueName);
                this.router.tell((Object)deleteMessageBucket, this.getSelf());
                this.sendedToDeletedBucketIds.add(deleteMessageBucket.bucketId);
                this.sendedToDeleteMessageMap.put(deleteMessageBucket.bucketId, deleteMessageBucket.messages.size());
            }
            logger.info("onReceive() : finish sending AWS delete messages to workers : amount : " + this.sendedToDeletedBucketIds.size());
        } else if (message instanceof TryDeleteAgainMessageBucket) {
            logger.info("onReceive() : receive try again delete message bucket");
            TryDeleteAgainMessageBucket tryAgainDeleteMessageBucket = (TryDeleteAgainMessageBucket)message;
            this.tryAgainMessageBucketMap.put(tryAgainDeleteMessageBucket.messageBucket.bucketId, tryAgainDeleteMessageBucket.messageBucket);
            this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
        } else if (message instanceof DeadLetter) {
            DeadLetter deadLetter = (DeadLetter)message;
            Object originalMessage = deadLetter.message();
            if (originalMessage instanceof DeleteFromQueueActor.MessageDropBucket) {
                DeleteFromQueueActor.MessageDropBucket deleteMessage = (DeleteFromQueueActor.MessageDropBucket)originalMessage;
                if (deleteMessage.queueName.equals(this.queueName)) {
                    logger.info("onReceive() : receive DeadLetter message bucket");
                    this.tryAgainMessageBucketMap.put(deleteMessage.bucketId, deleteMessage);
                    this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
                }
            }
        } else if (message instanceof DeleteFromQueueActor.MessageDropBucket) {
            logger.info("onReceive() : receive successful deleted message bucket");
            DeleteFromQueueActor.MessageDropBucket successfulDeletedMessageBucket = (DeleteFromQueueActor.MessageDropBucket)message;
            this.sendedToDeletedBucketIds.remove(successfulDeletedMessageBucket.bucketId);
            this.successfulDeletedAmount += (long)successfulDeletedMessageBucket.messages.size();
            this.sendedToDeleteMessageMap.remove(successfulDeletedMessageBucket.bucketId);
            this.tryAgainMessageBucketMap.remove(successfulDeletedMessageBucket.bucketId);
            if (this.whoAreInterestedInResult != null) {
                DeleteFromQueueTempReport tempReport = new DeleteFromQueueTempReport(successfulDeletedMessageBucket);
                this.whoAreInterestedInResult.tell((Object)tempReport, this.getSelf());
            }
            this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
        } else if (message == ReceiveTimeout.getInstance()) {
            this.sendReportAndStopTimeout();
        } else {
            this.unhandled(message);
        }
    }

    private void sendReportAndStopTimeout() {
        logger.info("sendReportAndStopTimeout()");
        int amountOfDeadMessage = 0;
        for (String eachKey : this.sendedToDeletedBucketIds) {
            Integer amount = this.sendedToDeleteMessageMap.get(eachKey);
            if (amount == null) continue;
            amountOfDeadMessage += amount.intValue();
        }
        if (this.whoAreInterestedInResult != null) {
            DeleteFromQueueReport deleteFromQueueReport = new DeleteFromQueueReport(this.startTime, System.currentTimeMillis(), amountOfDeadMessage, this.successfulDeletedAmount, this.tryAgainMessageBucketMap);
            this.whoAreInterestedInResult.tell((Object)deleteFromQueueReport, this.getSelf());
        }
        this.clearInnerState();
        this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
    }

    private void clearInnerState() {
        logger.info("clearInnerState()");
        this.startTime = 0L;
        this.successfulDeletedAmount = 0L;
        this.whoAreInterestedInResult = null;
        this.sendedToDeletedBucketIds.clear();
        this.sendedToDeleteMessageMap.clear();
        this.tryAgainMessageBucketMap.clear();
    }

    public static class DeleteFromQueueTempReport {
        public final DeleteFromQueueActor.MessageDropBucket wasSuccessfulSended;

        public DeleteFromQueueTempReport(DeleteFromQueueActor.MessageDropBucket wasSuccessfulSended) {
            this.wasSuccessfulSended = new DeleteFromQueueActor.MessageDropBucket(wasSuccessfulSended);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteFromQueueReport {
        public final long startTime;
        public final long finishTime;
        public final int amountOfDeadMessages;
        public final long successfulSendedAmount;
        public final Map<String, DeleteFromQueueActor.MessageDropBucket> tryAgainMessageBucket;

        public DeleteFromQueueReport(long startTime, long finishTime, int amountOfDeadMessages, long successfulSendedAmount, Map<String, DeleteFromQueueActor.MessageDropBucket> tryAgainMessageBucket) {
            this.startTime = startTime;
            this.finishTime = finishTime;
            this.amountOfDeadMessages = amountOfDeadMessages;
            this.successfulSendedAmount = successfulSendedAmount;
            this.tryAgainMessageBucket = new HashMap<String, DeleteFromQueueActor.MessageDropBucket>();
            for (String eachKey : tryAgainMessageBucket.keySet()) {
                DeleteFromQueueActor.MessageDropBucket originalBucket = tryAgainMessageBucket.get(eachKey);
                if (originalBucket == null) continue;
                DeleteFromQueueActor.MessageDropBucket newBucket = new DeleteFromQueueActor.MessageDropBucket(originalBucket);
                this.tryAgainMessageBucket.put(eachKey, newBucket);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (DeleteFromQueueActor.MessageDropBucket eachValue : this.tryAgainMessageBucket.values()) {
                stringBuilder.append(eachValue.toString());
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            return "DeleteFromQueueReport{time =" + (this.finishTime - this.startTime) + ", deadMessages.size()=" + this.amountOfDeadMessages + ", successfulDeletedAmount=" + this.successfulSendedAmount + ", notSendetMessages=" + stringBuilder.toString() + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteTheseMessages {
        public final List<Map<String, String>> messageList = new ArrayList<Map<String, String>>();

        public DeleteTheseMessages(List<Map<String, String>> messageList) {
            for (Map<String, String> eachMap : messageList) {
                HashMap<String, String> tmpMap = new HashMap<String, String>(eachMap);
                this.messageList.add(tmpMap);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteTheseAWSMessages {
        public final List<Message> awsMessageList = new ArrayList<Message>();

        public DeleteTheseAWSMessages(List<Message> awsMessageList) {
            this.awsMessageList.addAll(awsMessageList);
        }
    }

    public static class TryDeleteAgainMessageBucket {
        public final DeleteFromQueueActor.MessageDropBucket messageBucket;

        public TryDeleteAgainMessageBucket(DeleteFromQueueActor.MessageDropBucket messageBucket) {
            this.messageBucket = new DeleteFromQueueActor.MessageDropBucket(messageBucket);
        }
    }
}

