/*
 * Decompiled with CFR 0.152.
 */
package aws;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActorFactory;
import akka.routing.BroadcastRouter;
import akka.routing.RoundRobinRouter;
import akka.routing.RouterConfig;
import audit.RouterNames;
import aws.PutDnaAccountIntoQueueActor;
import aws.ReplaceDnaAccountFromQueueToTempQueueActor;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import dna.BaseActor;
import exceptions.ServiceException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class Sqs {
    private static final Logger logger = LoggerFactory.getLogger(Sqs.class);
    private static AmazonSQS sqs;
    private static ActorSystem system;
    private static final int NUMBER_OF_SQS_WRITERS = 5;
    private static final int NUMBER_OF_SQS_REPLACERS = 100;
    private static String dnaAccountsQueueUrl;
    private static String tmpDnaAccountsQueueUrl;
    private static String dnaAccountsQueueName;
    private static final int MAX_TIME_TO_WAIT_BEFORE_SEND_REPORT_IN_MIN = 5;

    public static ActorSystem getActorSystem() {
        Sqs.isInitialized();
        return system;
    }

    public static void initialize(ActorSystem actorSystem, String accountsQueueName, String regionName) {
        if (actorSystem == null || accountsQueueName == null || accountsQueueName.isEmpty() || regionName == null || regionName.isEmpty()) {
            throw new ServiceException("Some of the initialized param is null or empty", null);
        }
        dnaAccountsQueueName = accountsQueueName;
        if (system == null) {
            logger.info("Sqs : initialize with actor system");
            system = actorSystem;
            logger.info("Getting Started with Amazon SQS");
            sqs = new AmazonSQSClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider());
            Region region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
            sqs.setRegion(region);
            dnaAccountsQueueUrl = null;
            for (String queueUrl : sqs.listQueues().getQueueUrls()) {
                if (!queueUrl.endsWith(accountsQueueName)) continue;
                dnaAccountsQueueUrl = queueUrl;
                logger.info("Found dnaAccountQueue with url : " + dnaAccountsQueueUrl);
                break;
            }
            if (dnaAccountsQueueUrl == null) {
                CreateQueueRequest createQueueRequest = new CreateQueueRequest(accountsQueueName);
                dnaAccountsQueueUrl = sqs.createQueue(createQueueRequest).getQueueUrl();
                logger.info("There is no dnaAccountQueue : create new one with url : " + dnaAccountsQueueUrl);
            }
            system.actorOf(PutDnaAccountIntoQueueActor.props(dnaAccountsQueueUrl, sqs).withRouter((RouterConfig)new RoundRobinRouter(5).withSupervisorStrategy(SupervisorStrategy.defaultStrategy())), RouterNames.PUT_DNA_ACCOUNT_INTO_QUEUE_ROUTER.name());
        } else {
            logger.info("Sqs : already initialized");
        }
    }

    public static void initializeWithTempQueue(ActorSystem actorSystem, String accountsQueueName, String regionName, ActorRef dnaAccountReceiver, ActorRef master) {
        Sqs.initialize(actorSystem, accountsQueueName, regionName);
        String tmpQueueName = dnaAccountsQueueName + "-" + UUID.randomUUID().toString();
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(tmpQueueName);
        tmpDnaAccountsQueueUrl = sqs.createQueue(createQueueRequest).getQueueUrl();
        logger.info("Create tmpDnaAccountsQueue with url : " + tmpDnaAccountsQueueUrl);
        Region region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
        system.actorOf(ReplaceDnaAccountFromQueueToTempQueueActor.props(dnaAccountsQueueUrl, tmpDnaAccountsQueueUrl, dnaAccountReceiver, system.actorOf(ReporterActor.props(master)), sqs).withRouter((RouterConfig)new BroadcastRouter(100).withSupervisorStrategy(SupervisorStrategy.defaultStrategy())), RouterNames.REPLACE_DNA_ACCOUNT_INTO_TEMP_QUEUE_BROUDCAST_ROUTER.name());
        system.actorOf(ReplaceDnaAccountFromQueueToTempQueueActor.props(tmpDnaAccountsQueueUrl, dnaAccountsQueueUrl, null, system.actorOf(ReporterActor.props(master)), sqs).withRouter((RouterConfig)new BroadcastRouter(100).withSupervisorStrategy(SupervisorStrategy.defaultStrategy())), RouterNames.REPLACE_DNA_ACCOUNT_INTO_QUEUE_FROM_TEMP_QUEUE_BROUDCAST_ROUTER.name());
    }

    public static void deleteTempQueue() {
        Sqs.isInitialized();
        sqs.deleteQueue(new DeleteQueueRequest(tmpDnaAccountsQueueUrl));
    }

    public static void informAboutNewDnaAccountId(String dnaAccountId) {
        Sqs.isInitialized();
        system.actorFor("/user/" + RouterNames.PUT_DNA_ACCOUNT_INTO_QUEUE_ROUTER.name()).tell((Object)dnaAccountId, null);
    }

    public static void fetchAllDnaAccountIdAndSendItTo() {
        Sqs.isInitialized();
        system.actorFor("/user/" + RouterNames.REPLACE_DNA_ACCOUNT_INTO_TEMP_QUEUE_BROUDCAST_ROUTER.name()).tell((Object)new ReplaceDnaAccountFromQueueToTempQueueActor.Start(), null);
    }

    public static void replaceEverythingFromTempToQueue() {
        Sqs.isInitialized();
        system.actorFor("/user/" + RouterNames.REPLACE_DNA_ACCOUNT_INTO_QUEUE_FROM_TEMP_QUEUE_BROUDCAST_ROUTER.name()).tell((Object)new ReplaceDnaAccountFromQueueToTempQueueActor.Start(), null);
    }

    private static void isInitialized() {
        if (system == null || sqs == null) {
            throw new ServiceException("Sqs has not been initialized correctly", null);
        }
    }

    public static class ReporterActor
    extends BaseActor {
        private ActorRef master;
        private long startTime = 0L;
        private long startAmount = 0L;
        private long endAmount = 0L;
        private long amountOfMessages = 0L;
        private long amountOfFailedMessages = 0L;
        private long endTime;
        private String lastDescription;
        private static final Logger logger = LoggerFactory.getLogger(ReporterActor.class);

        public ReporterActor(ActorRef master) {
            this.master = master;
        }

        public void onReceive(Object o) throws Exception {
            if (o instanceof ReplaceDnaAccountFromQueueToTempQueueActor.Start) {
                ReplaceDnaAccountFromQueueToTempQueueActor.Start message = (ReplaceDnaAccountFromQueueToTempQueueActor.Start)o;
                if (this.startTime == 0L || this.startTime > message.getStartTime()) {
                    this.startTime = message.getStartTime();
                }
                ++this.startAmount;
            } else if (o instanceof ReplaceDnaAccountFromQueueToTempQueueActor.Stop) {
                this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
                ++this.endAmount;
                ReplaceDnaAccountFromQueueToTempQueueActor.Stop stopMessage = (ReplaceDnaAccountFromQueueToTempQueueActor.Stop)o;
                this.lastDescription = stopMessage.getDescription();
                this.amountOfMessages += stopMessage.getNumberOfMessages();
                this.amountOfFailedMessages += stopMessage.getNumberOfFailedMessages();
                if (this.endTime == 0L || this.endTime < stopMessage.getStopTime()) {
                    this.endTime = stopMessage.getStopTime();
                }
                if (this.endAmount == this.startAmount) {
                    ReplaceDnaAccountFromQueueToTempQueueActor.Stop finalStopMessage = new ReplaceDnaAccountFromQueueToTempQueueActor.Stop(this.endTime - this.startTime, this.amountOfMessages, this.amountOfFailedMessages, this.lastDescription);
                    this.master.tell((Object)finalStopMessage, null);
                    this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
                } else {
                    this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.MINUTES));
                }
            } else if (o == ReceiveTimeout.getInstance()) {
                ReplaceDnaAccountFromQueueToTempQueueActor.Stop finalStopMessage = new ReplaceDnaAccountFromQueueToTempQueueActor.Stop(this.endTime - this.startTime, this.amountOfMessages, this.amountOfFailedMessages, this.lastDescription);
                this.master.tell((Object)finalStopMessage, null);
                this.startTime = -1L;
                this.startAmount = 0L;
                this.endAmount = 0L;
                this.amountOfMessages = 0L;
                this.amountOfFailedMessages = 0L;
                this.endTime = 0L;
                this.lastDescription = null;
                this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
            } else {
                this.unhandled(o);
            }
        }

        public static Props props(final ActorRef master) {
            return new Props(new UntypedActorFactory(){

                public Actor create() throws Exception {
                    return new ReporterActor(master);
                }
            });
        }
    }
}

