/*
 * Decompiled with CFR 0.152.
 */
package aws;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActorFactory;
import audit.Audit;
import audit.messages.ErrorMessage;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import dna.BaseActor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceDnaAccountFromQueueToTempQueueActor
extends BaseActor {
    public static final String ACTOR_NAME = "replace-dnaAccount-from-queue-into-temp-queue-actor";
    private static final int HOW_LONG_WAIT_BEFORE_NEXT_CIRCLE_IN_MILLISEC = 10;
    private static final int HOW_LONG_WAIT_BEFORE_NEXT_TRY_AFTER_EMPTY_LIST_IN_SECOND = 5;
    private static final int MAX_NUMBER_OF_EMPTY_MESSAGE_LIST = 10;
    private final String queueUrl;
    private final String tempQueueUrl;
    private final ActorRef dnaAccountReceiverActor;
    private final ActorRef masterActor;
    private int howManyTimesWeReceiveEmptyMessageList;
    private AmazonSQS sqs;
    private long startTime;
    private long numberOfMessages = 0L;
    private long failedMessages = 0L;
    private static final Logger logger = LoggerFactory.getLogger(ReplaceDnaAccountFromQueueToTempQueueActor.class);

    public ReplaceDnaAccountFromQueueToTempQueueActor(String queueUrl, String tempQueueUrl, ActorRef dnaAccountReceiverActor, ActorRef master, AmazonSQS sqs) {
        this.queueUrl = queueUrl;
        this.tempQueueUrl = tempQueueUrl;
        this.dnaAccountReceiverActor = dnaAccountReceiverActor;
        this.masterActor = master;
        this.sqs = sqs;
    }

    public static Props props(final String urlQueue, final String tempUrlQueue, final ActorRef currentDnaAccountReceiverActor, final ActorRef master, final AmazonSQS squeue) {
        return new Props(new UntypedActorFactory(){

            public Actor create() throws Exception {
                return new ReplaceDnaAccountFromQueueToTempQueueActor(urlQueue, tempUrlQueue, currentDnaAccountReceiverActor, master, squeue);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(Object o) throws Exception {
        if (o instanceof Start || o == ReceiveTimeout.getInstance()) {
            if (o instanceof Start) {
                logger.info("Start replacing accounts from queue to tempQueue");
                this.howManyTimesWeReceiveEmptyMessageList = 0;
                this.startTime = System.currentTimeMillis();
                this.numberOfMessages = 0L;
                this.masterActor.tell(o, null);
                this.getContext().setReceiveTimeout((Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
            } else {
                logger.info("Proceed replacing accounts from queue to tempQueue");
            }
            try {
                List<Message> messages = this.fetchMessagesFromTheQueue(this.queueUrl);
                if (messages == null || messages.isEmpty()) {
                    ++this.howManyTimesWeReceiveEmptyMessageList;
                    this.getContext().setReceiveTimeout((Duration)Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
                    if (this.howManyTimesWeReceiveEmptyMessageList != 10) return;
                    logger.info("Receive empty list 10 times. Stop job.");
                    if (this.masterActor != null) {
                        Stop stop = new Stop(System.currentTimeMillis() - this.startTime, this.numberOfMessages, this.failedMessages, "From " + this.queueUrl + " to " + this.tempQueueUrl);
                        this.masterActor.tell((Object)stop, null);
                    }
                    this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
                    return;
                }
                this.howManyTimesWeReceiveEmptyMessageList = 0;
                this.putMessagesIntoQueue(this.tempQueueUrl, messages);
                this.deleteMessagesFromQueue(this.queueUrl, messages);
                this.numberOfMessages += (long)messages.size();
                if (this.dnaAccountReceiverActor == null) return;
                for (Message eachMessage : messages) {
                    this.dnaAccountReceiverActor.tell((Object)eachMessage.getBody(), null);
                }
                return;
            }
            catch (AmazonServiceException e) {
                this.failedMessages += 10L;
                ErrorMessage errorMessage = new ErrorMessage(e);
                Audit.getActorSystem().eventStream().publish((Object)errorMessage);
                return;
            }
        } else {
            this.unhandled(o);
        }
    }

    public List<Message> fetchMessagesFromTheQueue(String url) {
        logger.info("fetchMessagesFromTheQueue : " + url);
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(url);
        receiveMessageRequest.setMaxNumberOfMessages(Integer.valueOf(10));
        List messages = this.sqs.receiveMessage(receiveMessageRequest).getMessages();
        return messages;
    }

    public void deleteMessagesFromQueue(String url, List<Message> messages) {
        logger.info("deleteMessagesFromQueue : " + url);
        ArrayList<DeleteMessageBatchRequestEntry> deleteMessageBatchRequestEntries = new ArrayList<DeleteMessageBatchRequestEntry>();
        for (Message eachMessage : messages) {
            DeleteMessageBatchRequestEntry entry = new DeleteMessageBatchRequestEntry(UUID.randomUUID().toString(), eachMessage.getReceiptHandle());
            deleteMessageBatchRequestEntries.add(entry);
            if (deleteMessageBatchRequestEntries.size() != 10) continue;
            DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(url, deleteMessageBatchRequestEntries);
            this.sqs.deleteMessageBatch(deleteMessageBatchRequest);
            deleteMessageBatchRequestEntries = new ArrayList();
        }
        if (!deleteMessageBatchRequestEntries.isEmpty()) {
            DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(url, deleteMessageBatchRequestEntries);
            this.sqs.deleteMessageBatch(deleteMessageBatchRequest);
        }
    }

    public void putMessagesIntoQueue(String url, List<Message> messages) {
        logger.info("putMessagesIntoQueue : " + url);
        ArrayList<SendMessageBatchRequestEntry> sendMessageBatchRequestEntries = new ArrayList<SendMessageBatchRequestEntry>();
        for (Message eachMessage : messages) {
            SendMessageBatchRequestEntry entry = new SendMessageBatchRequestEntry(UUID.randomUUID().toString(), eachMessage.getBody());
            sendMessageBatchRequestEntries.add(entry);
            if (sendMessageBatchRequestEntries.size() != 10) continue;
            SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest(url, sendMessageBatchRequestEntries);
            this.sqs.sendMessageBatch(sendMessageBatchRequest);
            sendMessageBatchRequestEntries = new ArrayList();
        }
        if (!sendMessageBatchRequestEntries.isEmpty()) {
            SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest(url, sendMessageBatchRequestEntries);
            this.sqs.sendMessageBatch(sendMessageBatchRequest);
        }
    }

    public static class Stop {
        private long amountOfTime;
        private long numberOfMessages;
        private long numberOfFailedMessages;
        private long stopTime;
        private String description;

        public Stop(long amountOfTime, long numberOfMessages, long numberOfFailedMessages, String description) {
            this.amountOfTime = amountOfTime;
            this.numberOfMessages = numberOfMessages;
            this.numberOfFailedMessages = numberOfFailedMessages;
            this.description = description;
            this.stopTime = System.currentTimeMillis();
        }

        public long getAmountOfTime() {
            return this.amountOfTime;
        }

        public long getNumberOfMessages() {
            return this.numberOfMessages;
        }

        public String getDescription() {
            return this.description;
        }

        public long getNumberOfFailedMessages() {
            return this.numberOfFailedMessages;
        }

        public long getStopTime() {
            return this.stopTime;
        }

        public String toString() {
            return "Stop{amountOfTime=" + this.amountOfTime + ", numberOfMessages=" + this.numberOfMessages + ", numberOfFailedMessages=" + this.numberOfFailedMessages + ", description='" + this.description + '\'' + '}';
        }
    }

    public static class Start {
        private long startTime = System.currentTimeMillis();

        public long getStartTime() {
            return this.startTime;
        }
    }
}

