/*
 * Decompiled with CFR 0.152.
 */
package aws;

import akka.actor.Actor;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import dna.BaseActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutDnaAccountIntoQueueActor
extends BaseActor {
    public static final String ACTOR_NAME = "put-dnaAccount-into-queue-actor";
    private final String queueUrl;
    private AmazonSQS sqs;
    private static final Logger logger = LoggerFactory.getLogger(PutDnaAccountIntoQueueActor.class);

    public PutDnaAccountIntoQueueActor(String queueUrl, AmazonSQS sqs) {
        this.queueUrl = queueUrl;
        this.sqs = sqs;
    }

    public static Props props(final String urlQueue, final AmazonSQS squeue) {
        return new Props(new UntypedActorFactory(){

            public Actor create() throws Exception {
                return new PutDnaAccountIntoQueueActor(urlQueue, squeue);
            }
        });
    }

    public void onReceive(Object o) throws Exception {
        if (o instanceof String) {
            String message = (String)o;
            logger.info("Send dnaAccountId into queue : dnaAccountId : " + message);
            SendMessageRequest sendMessageRequest = new SendMessageRequest(this.queueUrl, message);
            this.sqs.sendMessage(sendMessageRequest);
        } else {
            this.unhandled(o);
        }
    }
}

