/*
 * Decompiled with CFR 0.152.
 */
package audit;

import akka.actor.UntypedActor;
import audit.messages.AuditMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditReceiverDatabaseActor
extends UntypedActor {
    public static final String ACTOR_NAME = "audit-receiver-database-actor";
    private static final Logger logger = LoggerFactory.getLogger(AuditReceiverDatabaseActor.class);
    private static final String insertString = "INSERT INTO audit (unique_id, event_type, event_when, description) VALUES (?, ?, ?, ?)";
    private Connection connection = null;
    private DataSource dataSource = null;

    public AuditReceiverDatabaseActor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof AuditMessage) {
            AuditMessage auditMessage = (AuditMessage)message;
            logger.info("Received AuditMessage message: {}", message);
            PreparedStatement statement = this.connection.prepareStatement(insertString);
            statement.setString(1, auditMessage.getUniqueId());
            statement.setString(2, auditMessage.getType());
            String when = auditMessage.getWhen().toLocalDate().toString();
            statement.setString(3, when);
            statement.setString(4, auditMessage.getDescription());
            statement.executeUpdate();
        } else {
            this.unhandled(message);
        }
    }

    public void initializeDBConnection() {
        logger.info("initializeDBConnection() : initialize connection to DB");
        try {
            this.connection = this.dataSource.getConnection();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            logger.error("Error initialize DB", (Throwable)e);
        }
    }

    public void closeDbConnection() {
        logger.info("closeDbConnection() : close DB connection");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            logger.error("Error close DB connection", (Throwable)e);
        }
    }

    public void preStart() {
        logger.info("preStart()");
        this.initializeDBConnection();
    }

    public void postRestart(Throwable reason) {
        logger.info("postRestart()");
        this.initializeDBConnection();
    }

    public void postStop() {
        logger.info("postStop()");
        this.closeDbConnection();
    }

    public void preRestart(Throwable reason, Option<Object> message) {
        logger.info("preRestart()");
        this.closeDbConnection();
    }
}

