/*
 * Decompiled with CFR 0.152.
 */
package audit;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActorFactory;
import akka.routing.RoundRobinRouter;
import akka.routing.RouterConfig;
import audit.AuditReceiverActor;
import audit.AuditReceiverDatabaseActor;
import audit.DeadLetterListenerAndPutIntoDBActor;
import audit.DeadLetterReceiverActor;
import audit.DeadLetterReceiverDatabaseActor;
import audit.ErrorMessageReceiverActor;
import audit.ErrorMessageReceiverDatabaseActor;
import audit.RouterNames;
import audit.messages.AuditMessage;
import audit.messages.ErrorMessage;
import exceptions.ServiceException;
import javax.sql.DataSource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Audit {
    private static final Logger logger = LoggerFactory.getLogger(Audit.class);
    private static ActorSystem system;
    private static final int NUMBER_OF_DB_WRITERS = 10;
    private static boolean isDatabaseAuditEnabled;

    public static void initializeWithDatabase(ActorSystem actorSystem, final DataSource dataSource) {
        if (actorSystem == null) {
            throw new ServiceException("actorSystem is null", null);
        }
        if (system == null) {
            logger.info("Audit : initialize with actor system");
            system = actorSystem;
            system.actorOf(new Props(new UntypedActorFactory(){

                public Actor create() throws Exception {
                    return new AuditReceiverDatabaseActor(dataSource);
                }
            }).withRouter((RouterConfig)new RoundRobinRouter(10).withSupervisorStrategy(SupervisorStrategy.defaultStrategy())), RouterNames.WRITE_TO_AUDIT_DB_ROUTER.name());
            system.actorOf(new Props(new UntypedActorFactory(){

                public Actor create() throws Exception {
                    return new ErrorMessageReceiverDatabaseActor(dataSource);
                }
            }).withRouter((RouterConfig)new RoundRobinRouter(10).withSupervisorStrategy(SupervisorStrategy.defaultStrategy())), RouterNames.WRITE_TO_ERROR_DB_ROUTER.name());
            system.actorOf(new Props(new UntypedActorFactory(){

                public Actor create() throws Exception {
                    return new DeadLetterReceiverDatabaseActor(dataSource);
                }
            }).withRouter((RouterConfig)new RoundRobinRouter(10).withSupervisorStrategy(SupervisorStrategy.defaultStrategy())), RouterNames.WRITE_TO_DEAD_DB_ROUTER.name());
            ActorRef deadLetterReceiver = system.actorOf(new Props(DeadLetterListenerAndPutIntoDBActor.class), "dead-letter-listener-and-put-into-db-actor");
            system.eventStream().subscribe(deadLetterReceiver, DeadLetter.class);
            isDatabaseAuditEnabled = true;
        } else {
            logger.info("Audit : already initialized");
        }
    }

    public static void initialize(ActorSystem actorSystem) {
        if (actorSystem == null) {
            throw new ServiceException("actorSystem is null", null);
        }
        if (system == null) {
            logger.info("Audit : initialize with actor system");
            system = actorSystem;
            ActorRef auditReceiver = system.actorOf(new Props(AuditReceiverActor.class), "audit-receiver-actor");
            system.eventStream().subscribe(auditReceiver, AuditMessage.class);
            ActorRef deadLetterReceiver = system.actorOf(new Props(DeadLetterReceiverActor.class), "dead-letter-receiver-actor");
            system.eventStream().subscribe(deadLetterReceiver, DeadLetter.class);
            ActorRef errorMessageReceiver = system.actorOf(new Props(ErrorMessageReceiverActor.class), "error-message-receiver-actor");
            system.eventStream().subscribe(errorMessageReceiver, ErrorMessage.class);
        } else {
            logger.info("Audit : already initialized");
        }
    }

    private static void isInitialized() {
        if (system == null) {
            throw new ServiceException("Audit has not been initialized correctly", null);
        }
    }

    public static void audit(String uniqueId, String type, String description) {
        Audit.isInitialized();
        AuditMessage message = new AuditMessage(uniqueId, type, DateTime.now(), description);
        if (isDatabaseAuditEnabled) {
            ActorRef routerWriteToDb = system.actorFor("/user/" + RouterNames.WRITE_TO_AUDIT_DB_ROUTER.name());
            routerWriteToDb.tell((Object)message, null);
        } else {
            system.eventStream().publish((Object)message);
        }
    }

    public static void error(Throwable reason, Object message, String accountId) {
        Audit.isInitialized();
        ErrorMessage errorMessage = new ErrorMessage(reason, message, accountId);
        if (isDatabaseAuditEnabled) {
            ActorRef routerWriteToDb = system.actorFor("/user/" + RouterNames.WRITE_TO_ERROR_DB_ROUTER.name());
            routerWriteToDb.tell((Object)errorMessage, null);
        } else {
            system.eventStream().publish((Object)errorMessage);
        }
    }

    static {
        isDatabaseAuditEnabled = false;
    }
}

