/*
 * Decompiled with CFR 0.152.
 */
package audit;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.Props;
import audit.AuditReceiverActor;
import audit.AuditorActor;
import audit.DeadLetterReceiverActor;
import audit.ErrorMessageReceiverActor;
import audit.messages.AuditMessage;
import audit.messages.ErrorMessage;
import exceptions.ServiceException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Audit {
    private static final Logger logger = LoggerFactory.getLogger(Audit.class);
    private static ActorSystem system;
    private static ActorRef auditorActor;

    public static void initialize(ActorSystem actorSystem) {
        if (actorSystem == null) {
            throw new ServiceException("actorSystem is null", null);
        }
        if (system != null || auditorActor != null) {
            throw new ServiceException("Audit system already initialized", null);
        }
        logger.info("Audit : initialize with actor system");
        system = actorSystem;
        auditorActor = system.actorOf(new Props(AuditorActor.class), "auditor-actor");
        ActorRef auditReceiver = system.actorOf(new Props(AuditReceiverActor.class), "audit-receiver-actor");
        system.eventStream().subscribe(auditReceiver, AuditMessage.class);
        ActorRef deadLetterReceiver = system.actorOf(new Props(DeadLetterReceiverActor.class), "dead-letter-receiver-actor");
        system.eventStream().subscribe(deadLetterReceiver, DeadLetter.class);
        ActorRef errorMessageReceiver = system.actorOf(new Props(ErrorMessageReceiverActor.class), "error-message-receiver-actor");
        system.eventStream().subscribe(errorMessageReceiver, ErrorMessage.class);
    }

    private static void isInitialized() {
        if (system == null || auditorActor == null) {
            throw new ServiceException("Audit has not been initialized correctly", null);
        }
    }

    public static void audit(String uniqueId, String description) {
        Audit.isInitialized();
        AuditMessage message = new AuditMessage(uniqueId, DateTime.now(), description);
        auditorActor.tell((Object)message);
    }
}

