/*
 * Decompiled with CFR 0.152.
 */
package redis;

import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    private static JedisPool jedisPool;

    public static void initialize(String host, int port) {
        if (jedisPool != null) {
            throw new IllegalStateException("Jedis already initialized");
        }
        jedisPool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), host, port);
    }

    public static Jedis getJedis() {
        if (jedisPool == null) {
            throw new IllegalStateException("Jedis is not initialized");
        }
        return (Jedis)jedisPool.getResource();
    }

    public static void returnJedis(Jedis jedis) {
        jedisPool.returnResource((Object)jedis);
    }

    public static void destroy() {
        jedisPool.destroy();
    }
}

