/*
 * Decompiled with CFR 0.152.
 */
package redis;

import exceptions.internal.RedisException;
import org.joda.time.LocalDateTime;
import redis.RedisManager;
import redis.clients.jedis.Jedis;

public class RedisCommon {
    public static long getCurrentRateFor(String application, String methodName) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            StringBuilder stringBuilder = new StringBuilder(application);
            stringBuilder.append("-");
            stringBuilder.append(methodName);
            stringBuilder.append("-");
            stringBuilder.append(Integer.toString(LocalDateTime.now().getMinuteOfHour()));
            String key = stringBuilder.toString();
            Long current = jedis.incr(key);
            jedis.expire(key, 60);
            if (current != null) {
                long l = current;
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable e) {
            throw new RedisException(e.getMessage(), e);
        }
        finally {
            if (jedis != null) {
                RedisManager.returnJedis(jedis);
            }
        }
    }
}

