/*
 * Decompiled with CFR 0.152.
 */
package constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RankCollections {
    ANCESTRAL_APE("Ancestral Ape", "\u041e\u0431\u0435\u0437\u044c\u044f\u043d\u0430 \u041f\u0440\u0435\u0434\u043a\u043e\u0432\u0430\u044f", 0, 10),
    MONKEY("Monkey", "\u041e\u0431\u0435\u0437\u044c\u044f\u043d\u0430", 11, 20),
    PRIMATE("Primate", "\u041f\u0440\u0438\u043c\u0430\u0442", 21, 30),
    ORANGUTAN("Orangutan", "\u041e\u0440\u0430\u043d\u0433\u0443\u0442\u0430\u043d\u0433", 31, 40),
    PIGMY_CHIMP("Pigmy Chimp", "\u041a\u0430\u0440\u043b\u0438\u043a\u043e\u0432\u044b\u0439 \u0428\u0438\u043c\u043f\u0430\u043d\u0437\u0435", 41, 50),
    ARCHAIC_MAN("Archaic Man", "\u0427\u0435\u043b\u043e\u0432\u0435\u043a \u0410\u0440\u0445\u0430\u0438\u0447\u043d\u044b\u0439", 51, 60),
    RHODESIAN_MAN("Rhodesian Man", "\u0427\u0435\u043b\u043e\u0432\u0435\u043a \u0420\u043e\u0434\u0435\u0437\u0438\u0439\u0441\u043a\u0438\u0439", 61, 70),
    NEANDERTHAL("Neanderthal", "\u041d\u0435\u0430\u043d\u0434\u0435\u0440\u0442\u0430\u043b\u0435\u0446", 71, 80),
    CRO_MAGNON("Cro-Magnon Man", "\u041a\u0440\u043e\u043c\u0430\u043d\u044c\u043e\u043d\u0435\u0446", 81, 90),
    MODERN_MAN("Modern Man", "\u0427\u0435\u043b\u043e\u0432\u0435\u043a \u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439", 91, 100),
    NONE("None", "None", 0, 0);

    private String rank_ru;
    private String rank_en;
    private int startPeriod;
    private int endPeriod;

    private RankCollections(String rank_en, String rank_ru, int startPeriod, int endPeriod) {
        this.rank_en = rank_en;
        this.rank_ru = rank_ru;
        this.startPeriod = startPeriod;
        this.endPeriod = endPeriod;
    }

    public String getRank_ru() {
        return this.rank_ru;
    }

    public String getRank_en() {
        return this.rank_en;
    }

    public boolean isValidFor(double score) {
        return (int)score >= this.startPeriod && (int)score <= this.endPeriod;
    }

    public static RankCollections getRankByScore(double score) {
        boolean isRankEnabled = true;
        if (!isRankEnabled) {
            return NONE;
        }
        for (RankCollections eachRankCollection : RankCollections.values()) {
            if (!eachRankCollection.isValidFor(score)) continue;
            return eachRankCollection;
        }
        throw new IllegalArgumentException("Wrong score");
    }
}

