/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside;

import constants.SocialNetworks;
import entities.common.CommentVO;
import entities.interfaces.Comment;
import exceptions.ForbiddenException;
import identity.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentHelper {
    public static Comment constructComment(String sourceObject, SocialNetworks socialNetwork, Token token) throws JSONException {
        switch (socialNetwork) {
            case Facebook: {
                return CommentHelper.createFacebookCommentFromJSON(sourceObject, token);
            }
            case Vkontakte: {
                return CommentHelper.createVkontakteCommentFromJSON(sourceObject, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    private static CommentVO createFacebookCommentFromJSON(String jsonString, Token at) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), at.getAccountId());
        }
        String id = object.getString("id");
        String fromid = object.getString("fromid");
        long time = object.getLong("time");
        int likes = object.getInt("likes");
        String text = object.getString("text");
        return new CommentVO(id, fromid, time, text, likes);
    }

    private static CommentVO createVkontakteCommentFromJSON(String jsonString, Token at) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Vkontakte communication failed." + object.getString("error"), at.getAccountId());
        }
        String id = object.getString("cid");
        String fromid = object.getString("uid");
        Long unixTime = object.getLong("date");
        JSONObject likesJsonObject = object.getJSONObject("likes");
        int likes = likesJsonObject.getInt("count");
        String text = object.getString("text");
        return new CommentVO(id, fromid, unixTime, text, likes);
    }

    public static Map<String, Set<Comment>> parseComments(String sourceJsonObject, Token token) throws JSONException {
        JSONObject object = new JSONObject(sourceJsonObject);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), token.getAccountId());
        }
        JSONArray commentListJsonObject = object.getJSONArray("data");
        HashMap<String, Set<Comment>> result = new HashMap<String, Set<Comment>>();
        for (int i = 0; i < commentListJsonObject.length(); ++i) {
            JSONObject eachJsonObject = commentListJsonObject.getJSONObject(i);
            String relatedPostId = eachJsonObject.getString("post_id");
            String id = eachJsonObject.getString("id");
            String fromid = eachJsonObject.getString("fromid");
            long time = eachJsonObject.getLong("time");
            int likes = eachJsonObject.getInt("likes");
            String text = eachJsonObject.getString("text");
            CommentVO commentVO = new CommentVO(id, fromid, time, text, likes);
            HashSet<CommentVO> tmpSet = (HashSet<CommentVO>)result.get(relatedPostId);
            if (tmpSet == null) {
                tmpSet = new HashSet<CommentVO>();
            }
            tmpSet.add(commentVO);
            result.put(relatedPostId, tmpSet);
        }
        return result;
    }
}

