/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import constants.SocialNetworks;
import entities.common.PostVO;
import entities.common.UserProfileVO;
import entities.fb.FbUserStateEntity;
import entities.interfaces.Comment;
import entities.interfaces.NetworkProvider;
import entities.interfaces.Post;
import entities.interfaces.UserProfile;
import entities.interfaces.UserState;
import entities.vk.VkUserStateEntity;
import exceptions.ServiceException;
import helpers.inside.NetworkProviderFactory;
import helpers.inside.vk.VkNetworkProvider;
import identity.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialGrabber {
    private static final Logger logger = LoggerFactory.getLogger(SocialGrabber.class);
    private static ExecutionContext executionContext = null;

    public static void initialize(ExecutionContext context) {
        logger.info("SocialGrabber : initialize()");
        executionContext = context;
    }

    private static void isInitialized() {
        if (executionContext == null) {
            throw new ServiceException("SocialGrabber has not been initialized correctly", null);
        }
    }

    @Deprecated
    public static UserState constructUserStateFromSocialNetworkWithAccessTokenSync(String socialNetworkAccessToken, SocialNetworks socialNetwork, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return SocialGrabber.createFromFacebookByAccessTokenSync(socialNetworkAccessToken, token);
            }
            case Vkontakte: {
                throw new IllegalStateException("Sync not supported any more");
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<UserState> constructUserStateFromSocialNetworkWithAccessToken(String socialNetworkAccessToken, SocialNetworks socialNetwork, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return SocialGrabber.createFromFacebookByAccessToken(socialNetworkAccessToken, token);
            }
            case Vkontakte: {
                return SocialGrabber.createFromVkontakteByAccessToken(socialNetworkAccessToken, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<UserState> constructUserStateFromSocialNetworkWithAccessTokenAndUserId(String friendId, String socialNetworkAccessToken, SocialNetworks socialNetwork, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return SocialGrabber.createFromFacebookByFriendIdAccessToken(friendId, socialNetworkAccessToken, token);
            }
            case Vkontakte: {
                return SocialGrabber.createFromVkontakteByAccessTokenAndUserId(friendId, socialNetworkAccessToken, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<Map<String, Boolean>> checkPermissionsStatusFromSocialNetworkByAccessToken(String socialNetworkAccessToken, SocialNetworks socialNetwork, List<String> permissions, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return SocialGrabber.checkPermissionsStatusFromFacebookByAccessToken(socialNetworkAccessToken, permissions, token);
            }
            case Vkontakte: {
                return SocialGrabber.checkPermissionsStatusFromVkontakteByAccessToken(socialNetworkAccessToken, permissions, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<Void> shareOnOwnWall(SocialNetworks socialNetwork, String eventCode, String locale, String socialNetworkAccessToken, String rank, int scores, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                return SocialGrabber.shareOnOwnWallInFacebook(eventCode, locale, socialNetworkAccessToken, rank, scores, token);
            }
            case Vkontakte: {
                return SocialGrabber.shareOnOwnWallInVkontakte(eventCode, locale, socialNetworkAccessToken, rank, scores, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<Void> shareOnFriendsWall(SocialNetworks socialNetwork, String eventCode, String locale, String socialNetworkAccessToken, String rank, int scores, String[] userIds, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                throw new IllegalArgumentException("Illegal social network");
            }
            case Vkontakte: {
                NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Vkontakte, executionContext);
                return provider.shareOnFriendsWall(eventCode, locale, socialNetworkAccessToken, rank, scores, userIds, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static Future<Void> shareOnFriendWall(SocialNetworks socialNetwork, String eventCode, String locale, String socialNetworkAccessToken, String rank, int scores, String userId, Token token) {
        SocialGrabber.isInitialized();
        switch (socialNetwork) {
            case Facebook: {
                throw new IllegalArgumentException("Illegal social network");
            }
            case Vkontakte: {
                NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Vkontakte, executionContext);
                return provider.shareOnFriendsWall(eventCode, locale, socialNetworkAccessToken, rank, scores, userId, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    private static Future<Void> shareOnOwnWallInFacebook(String eventCode, String locale, String socialNetworkAccessToken, String rank, int scores, Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, executionContext);
        return provider.shareOnOwnWall(eventCode, locale, socialNetworkAccessToken, rank, scores, token);
    }

    private static Future<Void> shareOnOwnWallInVkontakte(String eventCode, String locale, String socialNetworkAccessToken, String rank, int scores, Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Vkontakte, executionContext);
        return provider.shareOnOwnWall(eventCode, locale, socialNetworkAccessToken, rank, scores, token);
    }

    private static Future<Map<String, Boolean>> checkPermissionsStatusFromFacebookByAccessToken(String socialNetworkAccessToken, List<String> permissions, Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, executionContext);
        return provider.checkPermissionsStatusByAccessToken(socialNetworkAccessToken, permissions, token);
    }

    private static Future<Map<String, Boolean>> checkPermissionsStatusFromVkontakteByAccessToken(String socialNetworkAccessToken, List<String> permissions, Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Vkontakte, executionContext);
        return provider.checkPermissionsStatusByAccessToken(socialNetworkAccessToken, permissions, token);
    }

    private static Future<UserState> createFromVkontakteByAccessToken(final String vkontakteAccessToken, final Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Vkontakte, executionContext);
        final VkNetworkProvider vkProvider = (VkNetworkProvider)provider;
        Future<Map<String, Object>> bigMapFuture = vkProvider.fetchUserProfileFriendsSubscribersAndPostsByAccessToken(vkontakteAccessToken, token);
        Future biggestMapFuture = bigMapFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> map) {
                Set postsWithComments = (Set)map.get("postsWithComments");
                ArrayList postIdList = new ArrayList();
                postIdList.addAll(postsWithComments);
                Collections.sort(postIdList);
                ArrayList<Integer> resultPostIds = new ArrayList<Integer>();
                for (int i = postIdList.size() - 1; i >= 0; --i) {
                    resultPostIds.add((Integer)postIdList.get(i));
                }
                return vkProvider.fetchCommentsRelatedToPostsByIdsAndAccessToken(resultPostIds, vkontakteAccessToken, token).flatMap((Function1)new Mapper<List<Set<Comment>>, Future<Map<String, Object>>>(){

                    public Future<Map<String, Object>> apply(final List<Set<Comment>> listOfComments) {
                        return Futures.future((Callable)new Callable<Map<String, Object>>(){

                            @Override
                            public Map<String, Object> call() throws Exception {
                                HashMap<String, Object> resultMap = new HashMap<String, Object>(map);
                                resultMap.put("commentsList", listOfComments);
                                return resultMap;
                            }
                        }, (ExecutionContext)executionContext);
                    }
                }, executionContext);
            }
        }, executionContext);
        Future createUserStateEntityFuture = biggestMapFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<UserState>>(){

            public Future<UserState> apply(Map<String, Object> map) {
                final UserProfile me = (UserProfile)map.get("me");
                final Set friends = (Set)map.get("friends");
                final Set subscribers = (Set)map.get("subscribers");
                Set posts = (Set)map.get("posts");
                Set postsWithComments = (Set)map.get("postsWithComments");
                List listOfCommentSet = (List)map.get("commentsList");
                ArrayList postIdList = new ArrayList();
                postIdList.addAll(postsWithComments);
                Collections.sort(postIdList);
                ArrayList resultPostIds = new ArrayList();
                for (int i = postIdList.size() - 1; i >= 0; --i) {
                    resultPostIds.add(postIdList.get(i));
                }
                Future resultPostFuture = SocialGrabber.combinePostsAndComments(posts, listOfCommentSet, resultPostIds);
                return resultPostFuture.flatMap((Function1)new Mapper<Set<Post>, Future<UserState>>(){

                    public Future<UserState> apply(final Set<Post> resulPosts) {
                        return Futures.future((Callable)new Callable<UserState>(){

                            @Override
                            public UserState call() throws Exception {
                                UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), me.getBirthdayDate(), me.getRelation(), SocialNetworks.Vkontakte.name());
                                HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
                                if (friends != null && !friends.isEmpty()) {
                                    for (UserProfile eachFriend : friends) {
                                        friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), eachFriend.getBirthdayDate(), eachFriend.getRelation(), SocialNetworks.Vkontakte.name()));
                                    }
                                }
                                HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
                                if (subscribers != null && !subscribers.isEmpty()) {
                                    for (UserProfile eachSubscriber : subscribers) {
                                        subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), eachSubscriber.getBirthdayDate(), eachSubscriber.getRelation(), SocialNetworks.Vkontakte.name()));
                                    }
                                }
                                HashSet<PostVO> postsVO = new HashSet<PostVO>();
                                if (resulPosts != null && !resulPosts.isEmpty()) {
                                    for (Post eachPost : resulPosts) {
                                        postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                                    }
                                }
                                VkUserStateEntity userState = new VkUserStateEntity(meVO.getId(), SocialNetworks.Vkontakte.name(), meVO, friendsVO, subscribersVO, postsVO, new HashSet<String>());
                                return userState;
                            }
                        }, (ExecutionContext)executionContext);
                    }
                }, executionContext);
            }
        }, executionContext);
        return createUserStateEntityFuture;
    }

    private static Future<UserState> createFromVkontakteByAccessTokenAndUserId(final String userId, final String vkontakteAccessToken, final Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Vkontakte, executionContext);
        final VkNetworkProvider vkProvider = (VkNetworkProvider)provider;
        Future<Map<String, Object>> bigMapFuture = vkProvider.fetchUserProfileFriendsSubscribersAndPostsByAccessTokenAndUserId(userId, vkontakteAccessToken, token);
        Future biggestMapFuture = bigMapFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> map) {
                Set postsWithComments = (Set)map.get("postsWithComments");
                ArrayList postIdList = new ArrayList();
                postIdList.addAll(postsWithComments);
                Collections.sort(postIdList);
                ArrayList<Integer> resultPostIds = new ArrayList<Integer>();
                for (int i = postIdList.size() - 1; i >= 0; --i) {
                    resultPostIds.add((Integer)postIdList.get(i));
                }
                return vkProvider.fetchCommentsRelatedToPostsByIdsAndAccessTokenAndUserId(userId, resultPostIds, vkontakteAccessToken, token).flatMap((Function1)new Mapper<List<Set<Comment>>, Future<Map<String, Object>>>(){

                    public Future<Map<String, Object>> apply(final List<Set<Comment>> listOfComments) {
                        return Futures.future((Callable)new Callable<Map<String, Object>>(){

                            @Override
                            public Map<String, Object> call() throws Exception {
                                HashMap<String, Object> resultMap = new HashMap<String, Object>(map);
                                resultMap.put("commentsList", listOfComments);
                                return resultMap;
                            }
                        }, (ExecutionContext)executionContext);
                    }
                }, executionContext);
            }
        }, executionContext);
        Future createUserStateEntityFuture = biggestMapFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<UserState>>(){

            public Future<UserState> apply(Map<String, Object> map) {
                final UserProfile me = (UserProfile)map.get("me");
                final Set friends = (Set)map.get("friends");
                final Set subscribers = (Set)map.get("subscribers");
                Set posts = (Set)map.get("posts");
                Set postsWithComments = (Set)map.get("postsWithComments");
                List listOfCommentSet = (List)map.get("commentsList");
                ArrayList postIdList = new ArrayList();
                postIdList.addAll(postsWithComments);
                Collections.sort(postIdList);
                ArrayList resultPostIds = new ArrayList();
                for (int i = postIdList.size() - 1; i >= 0; --i) {
                    resultPostIds.add(postIdList.get(i));
                }
                Future resultPostFuture = SocialGrabber.combinePostsAndComments(posts, listOfCommentSet, resultPostIds);
                return resultPostFuture.flatMap((Function1)new Mapper<Set<Post>, Future<UserState>>(){

                    public Future<UserState> apply(final Set<Post> resulPosts) {
                        return Futures.future((Callable)new Callable<UserState>(){

                            @Override
                            public UserState call() throws Exception {
                                UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), me.getBirthdayDate(), me.getRelation(), SocialNetworks.Vkontakte.name());
                                HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
                                if (friends != null && !friends.isEmpty()) {
                                    for (UserProfile eachFriend : friends) {
                                        friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), eachFriend.getBirthdayDate(), eachFriend.getRelation(), SocialNetworks.Vkontakte.name()));
                                    }
                                }
                                HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
                                if (subscribers != null && !subscribers.isEmpty()) {
                                    for (UserProfile eachSubscriber : subscribers) {
                                        subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), eachSubscriber.getBirthdayDate(), eachSubscriber.getRelation(), SocialNetworks.Vkontakte.name()));
                                    }
                                }
                                HashSet<PostVO> postsVO = new HashSet<PostVO>();
                                if (resulPosts != null && !resulPosts.isEmpty()) {
                                    for (Post eachPost : resulPosts) {
                                        postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                                    }
                                }
                                VkUserStateEntity userState = new VkUserStateEntity(meVO.getId(), SocialNetworks.Vkontakte.name(), meVO, friendsVO, subscribersVO, postsVO, new HashSet<String>());
                                return userState;
                            }
                        }, (ExecutionContext)executionContext);
                    }
                }, executionContext);
            }
        }, executionContext);
        return createUserStateEntityFuture;
    }

    private static Future<Set<Post>> combinePostsAndComments(final Set<Post> sourcePosts, final List<Set<Comment>> listOfCommentSet, final List<Integer> postsWithCommenIds) {
        return Futures.future((Callable)new Callable<Set<Post>>(){

            @Override
            public Set<Post> call() throws Exception {
                if (postsWithCommenIds.isEmpty()) {
                    return sourcePosts;
                }
                HashMap<String, Set> map = new HashMap<String, Set>();
                for (int i = 0; i < listOfCommentSet.size(); ++i) {
                    Integer postId = (Integer)postsWithCommenIds.get(i);
                    Set commentSet = (Set)listOfCommentSet.get(i);
                    map.put(postId.toString(), commentSet);
                }
                if (map.isEmpty()) {
                    return sourcePosts;
                }
                HashSet<Post> resultSet = new HashSet<Post>();
                for (Post eachPost : sourcePosts) {
                    if (map.get(eachPost.getPostId()) != null) {
                        Set commentSet = (Set)map.get(eachPost.getPostId());
                        resultSet.add(eachPost.attachComments(commentSet));
                        continue;
                    }
                    resultSet.add(eachPost);
                }
                return resultSet;
            }
        }, (ExecutionContext)executionContext);
    }

    private static Future<UserState> createFromFacebookByFriendIdAccessToken(String friendId, String facebookAccessToken, Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, executionContext);
        ArrayList<Object> futures = new ArrayList<Object>();
        Future<Map<String, Object>> fetchMeFuture = SocialGrabber.meByIdFuture(friendId, facebookAccessToken, provider, token);
        futures.add(fetchMeFuture);
        HashSet emptyFriendList = new HashSet();
        HashMap emptyFriendMap = new HashMap();
        emptyFriendMap.put("friends", emptyFriendList);
        Future fetchFriendsFuture = Futures.successful(emptyFriendMap);
        futures.add(fetchFriendsFuture);
        Future<Map<String, Object>> fetchSubscribersFuture = SocialGrabber.subscribersByIdFuture(friendId, facebookAccessToken, provider, token);
        futures.add(fetchSubscribersFuture);
        Future<Map<String, Object>> fetchPostsFuture = SocialGrabber.postsByIdFuture(friendId, facebookAccessToken, provider, token);
        futures.add(fetchPostsFuture);
        HashSet emptyAllLikes = new HashSet();
        HashMap emptyMapAllLikes = new HashMap();
        emptyMapAllLikes.put("likes", emptyAllLikes);
        Future fetchAllLikedObjectIdFuture = Futures.successful(emptyMapAllLikes);
        futures.add(fetchAllLikedObjectIdFuture);
        Future finalFuture = Futures.sequence(futures, (ExecutionContext)executionContext);
        Future createUserStateEntityFuture = finalFuture.flatMap((Function1)new Mapper<Iterable<Map<String, Object>>, Future<UserState>>(){

            public Future<UserState> apply(final Iterable<Map<String, Object>> resultMap) {
                return Futures.future((Callable)new Callable<UserState>(){

                    @Override
                    public UserState call() throws Exception {
                        UserProfile me = null;
                        Set friends = null;
                        Set subscribers = null;
                        Set posts = null;
                        Set allLikedObjectId = null;
                        for (Map eachMap : resultMap) {
                            if (eachMap.get("me") != null) {
                                me = (UserProfile)eachMap.get("me");
                                continue;
                            }
                            if (eachMap.get("friends") != null) {
                                friends = (Set)eachMap.get("friends");
                                continue;
                            }
                            if (eachMap.get("subscribers") != null) {
                                subscribers = (Set)eachMap.get("subscribers");
                                continue;
                            }
                            if (eachMap.get("posts") != null) {
                                posts = (Set)eachMap.get("posts");
                                continue;
                            }
                            if (eachMap.get("likes") == null) continue;
                            allLikedObjectId = (Set)eachMap.get("likes");
                        }
                        UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), me.getBirthdayDate(), me.getRelation(), SocialNetworks.Facebook.name());
                        HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
                        if (friends != null && !friends.isEmpty()) {
                            for (UserProfile eachFriend : friends) {
                                friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), me.getBirthdayDate(), me.getRelation(), SocialNetworks.Facebook.name()));
                            }
                        }
                        HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
                        if (subscribers != null && !subscribers.isEmpty()) {
                            for (UserProfile eachSubscriber : subscribers) {
                                subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), eachSubscriber.getBirthdayDate(), eachSubscriber.getRelation(), SocialNetworks.Facebook.name()));
                            }
                        }
                        HashSet<PostVO> postsVO = new HashSet<PostVO>();
                        if (posts != null && !posts.isEmpty()) {
                            for (Post eachPost : posts) {
                                postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                            }
                        }
                        FbUserStateEntity userState = new FbUserStateEntity(meVO.getId(), SocialNetworks.Facebook.name(), meVO, friendsVO, subscribersVO, postsVO, allLikedObjectId);
                        return userState;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        return createUserStateEntityFuture;
    }

    private static Future<UserState> createFromFacebookByAccessToken(String facebookAccessToken, Token token) {
        NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, executionContext);
        ArrayList<Future<Map<String, Object>>> futures = new ArrayList<Future<Map<String, Object>>>();
        Future<Map<String, Object>> fetchMeFuture = SocialGrabber.meFuture(facebookAccessToken, provider, token);
        futures.add(fetchMeFuture);
        Future<Map<String, Object>> fetchFriendsFuture = SocialGrabber.friendsFuture(facebookAccessToken, provider, token);
        futures.add(fetchFriendsFuture);
        Future<Map<String, Object>> fetchSubscribersFuture = SocialGrabber.subscribersFuture(facebookAccessToken, provider, token);
        futures.add(fetchSubscribersFuture);
        Future<Map<String, Object>> fetchPostsFuture = SocialGrabber.postsFuture(facebookAccessToken, provider, token);
        futures.add(fetchPostsFuture);
        Future<Map<String, Object>> fetchAllLikedObjectIdFuture = SocialGrabber.likesFuture(facebookAccessToken, provider, token);
        futures.add(fetchAllLikedObjectIdFuture);
        Future finalFuture = Futures.sequence(futures, (ExecutionContext)executionContext);
        Future createUserStateEntityFuture = finalFuture.flatMap((Function1)new Mapper<Iterable<Map<String, Object>>, Future<UserState>>(){

            public Future<UserState> apply(final Iterable<Map<String, Object>> resultMap) {
                return Futures.future((Callable)new Callable<UserState>(){

                    @Override
                    public UserState call() throws Exception {
                        UserProfile me = null;
                        Set friends = null;
                        Set subscribers = null;
                        Set posts = null;
                        Set allLikedObjectId = null;
                        for (Map eachMap : resultMap) {
                            if (eachMap.get("me") != null) {
                                me = (UserProfile)eachMap.get("me");
                                continue;
                            }
                            if (eachMap.get("friends") != null) {
                                friends = (Set)eachMap.get("friends");
                                continue;
                            }
                            if (eachMap.get("subscribers") != null) {
                                subscribers = (Set)eachMap.get("subscribers");
                                continue;
                            }
                            if (eachMap.get("posts") != null) {
                                posts = (Set)eachMap.get("posts");
                                continue;
                            }
                            if (eachMap.get("likes") == null) continue;
                            allLikedObjectId = (Set)eachMap.get("likes");
                        }
                        UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), me.getBirthdayDate(), me.getRelation(), SocialNetworks.Facebook.name());
                        HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
                        if (friends != null && !friends.isEmpty()) {
                            for (UserProfile eachFriend : friends) {
                                friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), eachFriend.getBirthdayDate(), eachFriend.getRelation(), SocialNetworks.Facebook.name()));
                            }
                        }
                        HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
                        if (subscribers != null && !subscribers.isEmpty()) {
                            for (UserProfile eachSubscriber : subscribers) {
                                subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), eachSubscriber.getBirthdayDate(), eachSubscriber.getRelation(), SocialNetworks.Facebook.name()));
                            }
                        }
                        HashSet<PostVO> postsVO = new HashSet<PostVO>();
                        if (posts != null && !posts.isEmpty()) {
                            for (Post eachPost : posts) {
                                postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                            }
                        }
                        FbUserStateEntity userState = new FbUserStateEntity(meVO.getId(), SocialNetworks.Facebook.name(), meVO, friendsVO, subscribersVO, postsVO, allLikedObjectId);
                        return userState;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        return createUserStateEntityFuture;
    }

    @Deprecated
    private static UserState createFromFacebookByAccessTokenSync(String fbAccessToken, Token token) {
        FbUserStateEntity userState = null;
        try {
            NetworkProvider provider = NetworkProviderFactory.createProvider(SocialNetworks.Facebook, executionContext);
            UserProfile me = provider.fetchUserProfileByAccessTokenSync(fbAccessToken, token);
            Set<UserProfile> friends = provider.fetchUserFriendsByAccessTokenSync(fbAccessToken, token);
            Set<UserProfile> subscribers = provider.fetchUserSubscribersByAccessTokenSync(fbAccessToken, token);
            Set<Post> posts = provider.fetchUserPostsFromOwnWallByAccessTokenSync(fbAccessToken, token);
            Set<String> allLikedObjectId = provider.fetchUserAllUserLikesByAccessTokenSync(fbAccessToken, token);
            UserProfileVO meVO = new UserProfileVO(me.getId(), me.getName(), me.getGender(), me.getLocale(), me.getEmail(), me.getPictureUrl(), me.getFriendCount(), me.getBirthdayDate(), me.getRelation(), SocialNetworks.Facebook.name());
            HashSet<UserProfileVO> friendsVO = new HashSet<UserProfileVO>();
            if (friends != null && !friends.isEmpty()) {
                for (UserProfile eachFriend : friends) {
                    friendsVO.add(new UserProfileVO(eachFriend.getId(), eachFriend.getName(), eachFriend.getGender(), eachFriend.getLocale(), eachFriend.getEmail(), eachFriend.getPictureUrl(), eachFriend.getFriendCount(), eachFriend.getBirthdayDate(), eachFriend.getRelation(), SocialNetworks.Facebook.name()));
                }
            }
            HashSet<UserProfileVO> subscribersVO = new HashSet<UserProfileVO>();
            if (subscribers != null && !subscribers.isEmpty()) {
                for (UserProfile eachSubscriber : subscribers) {
                    subscribersVO.add(new UserProfileVO(eachSubscriber.getId(), eachSubscriber.getName(), eachSubscriber.getGender(), eachSubscriber.getLocale(), eachSubscriber.getEmail(), eachSubscriber.getPictureUrl(), eachSubscriber.getFriendCount(), eachSubscriber.getBirthdayDate(), eachSubscriber.getRelation(), SocialNetworks.Facebook.name()));
                }
            }
            HashSet<PostVO> postsVO = new HashSet<PostVO>();
            if (posts != null && !posts.isEmpty()) {
                for (Post eachPost : posts) {
                    postsVO.add(new PostVO(eachPost.getPostId(), eachPost.getMessage(), eachPost.getLikes(), eachPost.getComments()));
                }
            }
            userState = new FbUserStateEntity(meVO.getId(), SocialNetworks.Facebook.name(), meVO, friendsVO, subscribersVO, postsVO, allLikedObjectId);
        }
        catch (Exception e) {
            throw new ServiceException("Error in Connecting to FB", (Throwable)e, token.getAccountId());
        }
        return userState;
    }

    private static Future<Map<String, Object>> meFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserProfileByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<UserProfile, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final UserProfile me) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("me", me);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> meByIdFuture(String friendId, String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserProfileByUserId(friendId, facebookAccessToken, token).flatMap((Function1)new Mapper<UserProfile, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final UserProfile me) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("me", me);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> friendsFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserFriendsByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<UserProfile>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<UserProfile> friends) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("friends", friends);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> subscribersFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserSubscribersByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<UserProfile>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<UserProfile> subscribers) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("subscribers", subscribers);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> subscribersByIdFuture(String friendId, String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserSubscribersByUserId(friendId, facebookAccessToken, token).flatMap((Function1)new Mapper<Set<UserProfile>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<UserProfile> subscribers) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("subscribers", subscribers);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> postsByIdFuture(String friendId, String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserPostsFromFriendWallByUserId(friendId, facebookAccessToken, token).flatMap((Function1)new Mapper<Set<Post>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<Post> posts) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("posts", posts);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> postsFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserPostsFromOwnWallByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<Post>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<Post> posts) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("posts", posts);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Future<Map<String, Object>> likesFuture(String facebookAccessToken, NetworkProvider provider, Token token) {
        return provider.fetchUserAllUserLikesByAccessToken(facebookAccessToken, token).flatMap((Function1)new Mapper<Set<String>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Set<String> likes) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>();
                        resultMap.put("likes", likes);
                        return resultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }
}

