/*
 * Decompiled with CFR 0.152.
 */
package entities.common;

import entities.common.CommentVO;
import entities.interfaces.Comment;
import entities.interfaces.Post;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostVO
implements Post {
    private final String postId;
    private final String message;
    private final int likes;
    private final Set<CommentVO> comments;
    private final int commentsSize;

    public PostVO(String postId, String message, int likes, Set<Comment> comments) {
        this.postId = postId;
        this.message = message;
        this.likes = likes;
        this.comments = new HashSet<CommentVO>();
        if (comments != null && !comments.isEmpty()) {
            for (Comment eachComment : comments) {
                this.comments.add((CommentVO)eachComment);
            }
        }
        this.commentsSize = this.comments.size();
    }

    public PostVO(String postId, String message, Set<CommentVO> comments, int likes) {
        this.postId = postId;
        this.message = message;
        this.likes = likes;
        this.comments = new HashSet<CommentVO>();
        if (comments != null && !comments.isEmpty()) {
            this.comments.addAll(comments);
        }
        this.commentsSize = this.comments.size();
    }

    public PostVO(String postId, String message, int likes, int commentsSize) {
        this.postId = postId;
        this.message = message;
        this.likes = likes;
        this.comments = new HashSet<CommentVO>();
        this.commentsSize = commentsSize;
    }

    @Override
    public String getPostId() {
        return this.postId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getLikes() {
        return this.likes;
    }

    @Override
    public Set<Comment> getComments() {
        HashSet<Comment> result = new HashSet<Comment>();
        if (this.comments != null && !this.comments.isEmpty()) {
            result.addAll(this.comments);
        }
        return result;
    }

    @Override
    public int getCommentsSize() {
        return this.commentsSize;
    }

    @Override
    public PostVO attachComments(Set<Comment> comments) {
        return new PostVO(this.postId, this.message, this.likes, comments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostVO postVO = (PostVO)o;
        return this.postId.equals(postVO.postId);
    }

    public int hashCode() {
        return this.postId.hashCode();
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostVO postVO = (PostVO)o;
        if (this.likes != postVO.likes) {
            return false;
        }
        if (this.message != null ? !this.message.equals(postVO.message) : postVO.message != null) {
            return false;
        }
        if (!this.postId.equals(postVO.postId)) {
            return false;
        }
        return this.comments.equals(postVO.comments);
    }
}

