/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside.vk;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.common.collect.Lists;
import constants.LocaleCollection;
import constants.MessageCollection;
import constants.SocialNetworks;
import constants.VkConstants;
import entities.interfaces.Comment;
import entities.interfaces.NetworkProvider;
import entities.interfaces.Post;
import entities.interfaces.UserProfile;
import exceptions.ForbiddenException;
import exceptions.ServiceException;
import exceptions.SocialNetworkException;
import exceptions.internal.SessionHasExpiredException;
import helpers.inside.CommentHelper;
import helpers.inside.PostHelper;
import helpers.inside.UserProfileHelper;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.WS;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import util.SocialNetworkPermissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VkNetworkProvider
implements NetworkProvider {
    private static final Logger logger = LoggerFactory.getLogger(VkNetworkProvider.class);
    private static VkNetworkProvider INSTANCE;
    private static ExecutionContext executionContext;
    private static final String BASE_REQUEST;

    public static VkNetworkProvider getInstance(ExecutionContext context) {
        if (INSTANCE == null) {
            return new VkNetworkProvider(context);
        }
        return INSTANCE;
    }

    private VkNetworkProvider(ExecutionContext context) {
        executionContext = context;
    }

    private static WS.WSRequestHolder postOnTheWallByAccessTokenAndUserIdRequest(String userId, String message, String link, String socialNetworkAccessToken) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/wall.post");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        if (message == null && link == null) {
            throw new IllegalArgumentException("message and link are both null");
        }
        if (userId != null) {
            requestHolder = requestHolder.setQueryParameter("owner_id", userId);
        }
        if (message != null) {
            requestHolder = requestHolder.setQueryParameter("message", message);
        }
        if (link != null) {
            requestHolder = requestHolder.setQueryParameter("attachments", link);
        }
        return requestHolder;
    }

    private static WS.WSRequestHolder permissionBitMaskByAccessToken(String socialNetworkAccessToken) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/account.getAppPermissions");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        return requestHolder;
    }

    private static WS.WSRequestHolder fetchCommentsRelatedtoPostByAccessTokenAndListOfPostIdRequest(String ownerId, String socialNetworkAccessToken, List<Integer> postIds) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/execute");
        int maxSize = postIds.size() <= 25 ? postIds.size() : 25;
        StringBuilder codeParam = new StringBuilder("return [");
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                codeParam.append(",");
            }
            if (ownerId == null || ownerId.isEmpty()) {
                codeParam.append("API.wall.getComments({\"post_id\":" + postIds.get(i).toString() + ",\"need_likes\":1})");
                continue;
            }
            codeParam.append("API.wall.getComments({\"owner_id\":" + ownerId + ",\"post_id\":" + postIds.get(i).toString() + ",\"need_likes\":1})");
        }
        codeParam.append("];");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        requestHolder = requestHolder.setQueryParameter("code", codeParam.toString());
        return requestHolder;
    }

    private static WS.WSRequestHolder fetchUserProfileFriendsAndSubscriberByAccessTokenRequest(String userId, String socialNetworkAccessToken) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/execute");
        StringBuilder codeParam = new StringBuilder("return [");
        if (userId == null || userId.isEmpty()) {
            codeParam.append("API.users.get({\"fields\":\"screen_name,sex,photo_200_orig,rate,contacts,counters\"})");
            codeParam.append(",");
            codeParam.append("API.friends.get({\"fields\":\"screen_name,sex,photo_200_orig,rate,contacts,counters\"})");
            codeParam.append(",");
            codeParam.append("API.users.getFollowers({\"fields\":\"screen_name,sex,photo,rate,contacts,counters\",\"count\":1000})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":0, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":100, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":200, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":300, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":400, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":500, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":600, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":700, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":800, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"filter\":\"owner\",\"offset\":900, \"count\":100})");
        } else {
            codeParam.append("API.users.get({\"user_ids\":\"" + userId + "\",\"fields\":\"screen_name,sex,photo_200_orig,rate,contacts,counters\"})");
            codeParam.append(",");
            codeParam.append("API.friends.get({\"user_id\":\"" + userId + "\",\"fields\":\"screen_name,sex,photo_200_orig,rate,contacts,counters\"})");
            codeParam.append(",");
            codeParam.append("API.users.getFollowers({\"user_id\":\"" + userId + "\",\"fields\":\"screen_name,sex,photo,rate,contacts,counters\",\"count\":1000})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":0, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":100, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":200, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":300, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":400, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":500, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":600, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":700, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":800, \"count\":100})");
            codeParam.append(",");
            codeParam.append("API.wall.get({\"owner_id\":\"" + userId + "\",\"filter\":\"owner\",\"offset\":900, \"count\":100})");
        }
        codeParam.append("];");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        requestHolder = requestHolder.setQueryParameter("code", codeParam.toString());
        return requestHolder;
    }

    public Future<Map<String, Object>> fetchUserProfileFriendsSubscribersAndPostsByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("VkNetworkProvider : fetchUserProfileFriendsAndSubscriberByAccessToken()");
        WS.WSRequestHolder requestHolder = VkNetworkProvider.fetchUserProfileFriendsAndSubscriberByAccessTokenRequest(null, socialNetworkAccessToken);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            JSONArray jsonArray;
                            HashMap<String, Object> result = new HashMap<String, Object>();
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            if ((jsonArray = object.getJSONArray("response")).length() != 13) {
                                logger.error("VkNetworkProvider : fetchUserProfileFriendsAndSubscriberByAccessToken() : error : Cannot parse Vkontakte response : Response length should be 13");
                                throw new ServiceException("Cannot parse Vkontakte response : Response length should be 13", token.getAccountId());
                            }
                            JSONArray userProfileJsonArray = jsonArray.getJSONArray(0);
                            UserProfile me = (UserProfile)Lists.newArrayList((Iterable)VkNetworkProvider.parseJsonArrayToUserProfileSet(userProfileJsonArray, token)).get(0);
                            JSONArray friendsProfilesJsonArray = jsonArray.getJSONArray(1);
                            Set friends = VkNetworkProvider.parseJsonArrayToUserProfileSet(friendsProfilesJsonArray, token);
                            JSONObject subscribersJsonObject = jsonArray.getJSONObject(2);
                            Set subscribers = new HashSet();
                            if (subscribersJsonObject.getInt("count") > 0) {
                                subscribers = VkNetworkProvider.parseJsonArrayToUserProfileSet(subscribersJsonObject.getJSONArray("items"), token);
                            }
                            result.put("me", me);
                            result.put("friends", friends);
                            result.put("subscribers", subscribers);
                            HashSet postsWithComments = new HashSet();
                            HashSet allPosts = new HashSet();
                            LocalDate longTimeAgo = LocalDate.now().minusDays(90);
                            for (int index = 3; index < 13; ++index) {
                                JSONArray postsAsJsonArray = jsonArray.getJSONArray(index);
                                Set posts = VkNetworkProvider.parseJsonArrayToPostSet(postsAsJsonArray, longTimeAgo, postsWithComments, token);
                                allPosts.addAll(posts);
                            }
                            result.put("posts", allPosts);
                            result.put("postsWithComments", postsWithComments);
                            return result;
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : fetchUserProfileFriendsAndSubscriberByAccessToken() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    public Future<Map<String, Object>> fetchUserProfileFriendsSubscribersAndPostsByAccessTokenAndUserId(String userId, String socialNetworkAccessToken, final Token token) {
        logger.info("VkNetworkProvider : fetchUserProfileFriendsSubscribersAndPostsByAccessTokenAndUserId()");
        WS.WSRequestHolder requestHolder = VkNetworkProvider.fetchUserProfileFriendsAndSubscriberByAccessTokenRequest(userId, socialNetworkAccessToken);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            JSONArray jsonArray;
                            HashMap<String, Object> result = new HashMap<String, Object>();
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            if ((jsonArray = object.getJSONArray("response")).length() != 13) {
                                logger.error("VkNetworkProvider : fetchUserProfileFriendsSubscribersAndPostsByAccessTokenAndUserId() : error : Cannot parse Vkontakte response : Response length should be 13");
                                throw new ServiceException("Cannot parse Vkontakte response : Response length should be 13", token.getAccountId());
                            }
                            JSONArray userProfileJsonArray = jsonArray.getJSONArray(0);
                            UserProfile me = (UserProfile)Lists.newArrayList((Iterable)VkNetworkProvider.parseJsonArrayToUserProfileSet(userProfileJsonArray, token)).get(0);
                            JSONArray friendsProfilesJsonArray = jsonArray.getJSONArray(1);
                            Set friends = VkNetworkProvider.parseJsonArrayToUserProfileSet(friendsProfilesJsonArray, token);
                            JSONObject subscribersJsonObject = jsonArray.getJSONObject(2);
                            Set subscribers = new HashSet();
                            if (subscribersJsonObject.getInt("count") > 0) {
                                subscribers = VkNetworkProvider.parseJsonArrayToUserProfileSet(subscribersJsonObject.getJSONArray("items"), token);
                            }
                            result.put("me", me);
                            result.put("friends", friends);
                            result.put("subscribers", subscribers);
                            HashSet postsWithComments = new HashSet();
                            HashSet allPosts = new HashSet();
                            LocalDate longTimeAgo = LocalDate.now().minusDays(90);
                            for (int index = 3; index < 13; ++index) {
                                JSONArray postsAsJsonArray = jsonArray.getJSONArray(index);
                                Set posts = VkNetworkProvider.parseJsonArrayToPostSet(postsAsJsonArray, longTimeAgo, postsWithComments, token);
                                allPosts.addAll(posts);
                            }
                            result.put("posts", allPosts);
                            result.put("postsWithComments", postsWithComments);
                            return result;
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : fetchUserProfileFriendsSubscribersAndPostsByAccessTokenAndUserId() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static Set<Post> parseJsonArrayToPostSet(JSONArray jsonArray, LocalDate longTimeAgo, Set<Integer> postsWithcommentsId, Token token) throws JSONException {
        HashSet<Post> result = new HashSet<Post>();
        if (jsonArray.length() > 1) {
            for (int index = 1; index < jsonArray.length(); ++index) {
                JSONObject childJSONObject = jsonArray.getJSONObject(index);
                Long unixTime = childJSONObject.getLong("date");
                long millisecTime = unixTime * 1000L;
                LocalDate postTime = new LocalDate(millisecTime);
                if (!postTime.isAfter((ReadablePartial)longTimeAgo)) continue;
                int postId = childJSONObject.getInt("id");
                JSONObject comments = childJSONObject.getJSONObject("comments");
                int commentsCount = comments.getInt("count");
                if (commentsCount > 0) {
                    postsWithcommentsId.add(postId);
                }
                Post post = PostHelper.constructPost(childJSONObject.toString(), SocialNetworks.Vkontakte, token);
                result.add(post);
            }
        }
        return result;
    }

    private static Set<UserProfile> parseJsonArrayToUserProfileSet(JSONArray jsonArray, Token token) throws JSONException {
        HashSet<UserProfile> result = new HashSet<UserProfile>();
        for (int index = 0; index < jsonArray.length(); ++index) {
            UserProfile userProfile = UserProfileHelper.constructUserProfile(jsonArray.getString(index), SocialNetworks.Vkontakte, token);
            result.add(userProfile);
        }
        return result;
    }

    public Future<List<Set<Comment>>> fetchCommentsRelatedToPostsByIdsAndAccessToken(final List<Integer> postIds, String socialNetworkAccessToken, final Token token) {
        logger.info("VkNetworkProvider : fetchCommentsRelatedToPostsByIdsAndAccessToken()");
        if (postIds.isEmpty()) {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            list.add(set);
            return Futures.successful(list);
        }
        WS.WSRequestHolder requestHolder = VkNetworkProvider.fetchCommentsRelatedtoPostByAccessTokenAndListOfPostIdRequest(null, socialNetworkAccessToken, postIds);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<List<Set<Comment>>>>(){

            public Future<List<Set<Comment>>> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<List<Set<Comment>>>(){

                    @Override
                    public List<Set<Comment>> call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            int size;
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            JSONArray jsonArray = object.getJSONArray("response");
                            int n = size = postIds.size() <= 25 ? postIds.size() : 25;
                            if (jsonArray.length() != size) {
                                logger.error("VkNetworkProvider : response : " + response.getBody());
                                logger.error("VkNetworkProvider : fetchCommentsRelatedToPostsByIdsAndAccessToken() : error : Cannot parse Vkontakte response : Response length should be the same like postIds");
                                throw new ServiceException("Cannot parse Vkontakte response : Cannot parse Vkontakte response : Response length should be the same like postIds", token.getAccountId());
                            }
                            ArrayList<Set<Comment>> result = new ArrayList<Set<Comment>>();
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                HashSet<Comment> commentSet = new HashSet<Comment>();
                                JSONArray array = jsonArray.getJSONArray(i);
                                for (int index = 1; index < array.length(); ++index) {
                                    Comment comment = CommentHelper.constructComment(array.getString(index), SocialNetworks.Vkontakte, token);
                                    commentSet.add(comment);
                                }
                                result.add(commentSet);
                            }
                            return result;
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : response : " + response.getBody());
                            logger.error("Error : " + e.getMessage());
                            logger.error("VkNetworkProvider : fetchCommentsRelatedToPostsByIdsAndAccessToken() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    public Future<List<Set<Comment>>> fetchCommentsRelatedToPostsByIdsAndAccessTokenAndUserId(String userId, final List<Integer> postIds, String socialNetworkAccessToken, final Token token) {
        logger.info("VkNetworkProvider : fetchCommentsRelatedToPostsByIdsAndAccessTokenAndUserId()");
        if (postIds.isEmpty()) {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            list.add(set);
            return Futures.successful(list);
        }
        WS.WSRequestHolder requestHolder = VkNetworkProvider.fetchCommentsRelatedtoPostByAccessTokenAndListOfPostIdRequest(userId, socialNetworkAccessToken, postIds);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<List<Set<Comment>>>>(){

            public Future<List<Set<Comment>>> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<List<Set<Comment>>>(){

                    @Override
                    public List<Set<Comment>> call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            int size;
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            JSONArray jsonArray = object.getJSONArray("response");
                            int n = size = postIds.size() <= 25 ? postIds.size() : 25;
                            if (jsonArray.length() != size) {
                                logger.error("VkNetworkProvider : response : " + response.getBody());
                                logger.error("VkNetworkProvider : fetchCommentsRelatedToPostsByIdsAndAccessTokenAndUserId() : error : Cannot parse Vkontakte response : Response length should be the same like postIds");
                                throw new ServiceException("Cannot parse Vkontakte response : Cannot parse Vkontakte response : Response length should be the same like postIds", token.getAccountId());
                            }
                            ArrayList<Set<Comment>> result = new ArrayList<Set<Comment>>();
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                HashSet<Comment> commentSet = new HashSet<Comment>();
                                JSONArray array = jsonArray.getJSONArray(i);
                                for (int index = 1; index < array.length(); ++index) {
                                    Comment comment = CommentHelper.constructComment(array.getString(index), SocialNetworks.Vkontakte, token);
                                    commentSet.add(comment);
                                }
                                result.add(commentSet);
                            }
                            return result;
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : response : " + response.getBody());
                            logger.error("Error : " + e.getMessage());
                            logger.error("VkNetworkProvider : fetchCommentsRelatedToPostsByIdsAndAccessTokenAndUserId() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private static WS.WSRequestHolder usersGetRequest(String socialNetworkAccessToken, List<String> userIds) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/users.get");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        if (userIds == null || userIds.isEmpty()) {
            requestHolder = requestHolder.setQueryParameter("fields", "sex,photo_200_orig,rate,counters");
            return requestHolder;
        }
        if (userIds.size() == 1) {
            requestHolder = requestHolder.setQueryParameter("fields", "sex,photo_200_orig,rate,counters");
            requestHolder = requestHolder.setQueryParameter("uids", userIds.get(0));
            return requestHolder;
        }
        StringBuilder userIdString = new StringBuilder();
        for (int i = 0; i < userIds.size(); ++i) {
            if (i > 0) {
                userIdString.append(",");
            }
            userIdString.append(userIds.get(i));
        }
        requestHolder = requestHolder.setQueryParameter("fields", "sex,photo_200_orig,rate");
        requestHolder = requestHolder.setQueryParameter("uids", userIdString.toString());
        return requestHolder;
    }

    private static WS.WSRequestHolder wallGetRequest(String socialNetworkAccessToken, int offset, int count, String ownerId) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/wall.get");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        requestHolder = requestHolder.setQueryParameter("filter", "owner");
        if (offset != 0) {
            requestHolder = requestHolder.setQueryParameter("offset", Integer.toString(offset));
        }
        if (count != 0) {
            requestHolder = requestHolder.setQueryParameter("count", Integer.toString(count));
        }
        if (ownerId != null) {
            requestHolder = requestHolder.setQueryParameter("owner_id", ownerId);
        }
        return requestHolder;
    }

    private static WS.WSRequestHolder wallGetCommentsRequest(int postId, String socialNetworkAccessToken, int offset, int count) {
        StringBuilder requestBuilder = new StringBuilder(BASE_REQUEST);
        requestBuilder.append("/wall.getComments");
        WS.WSRequestHolder requestHolder = WS.url((String)requestBuilder.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", socialNetworkAccessToken);
        requestHolder = requestHolder.setQueryParameter("post_id", Integer.toString(postId));
        requestHolder = requestHolder.setQueryParameter("need_likes", "1");
        if (offset != 0) {
            requestHolder = requestHolder.setQueryParameter("offset", Integer.toString(offset));
        }
        if (count != 0) {
            requestHolder = requestHolder.setQueryParameter("count", Integer.toString(count));
        }
        return requestHolder;
    }

    @Override
    public Future<UserProfile> fetchUserProfileByAccessToken(String socialNetworkAccessToken, final Token token) {
        logger.info("VkNetworkProvider : fetchUserProfileByAccessToken()");
        WS.WSRequestHolder requestHolder = VkNetworkProvider.usersGetRequest(socialNetworkAccessToken, null);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<UserProfile>>(){

            public Future<UserProfile> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<UserProfile>(){

                    @Override
                    public UserProfile call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            JSONArray jsonArray = object.getJSONArray("response");
                            ArrayList<UserProfile> userProfiles = new ArrayList<UserProfile>();
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject childJSONObject = jsonArray.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserProfile(childJSONObject.toString(), SocialNetworks.Vkontakte, token);
                                userProfiles.add(userProfile);
                            }
                            if (userProfiles.isEmpty() || userProfiles.size() != 1) {
                                logger.error("VkNetworkProvider : fetchUserProfileByAccessToken() : error : Cannot parse Vkontakte response");
                                throw new ServiceException("Cannot parse Vkontakte response", token.getAccountId());
                            }
                            return (UserProfile)userProfiles.get(0);
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : fetchUserProfileByAccessToken() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    private void throwExceptionDependsOnError(JSONObject object, Token token) {
        try {
            int code;
            JSONObject errorObject = object.getJSONObject("error");
            if (errorObject.has("error_code") && (code = errorObject.getInt("error_code")) == 5) {
                logger.error("VkNetworkProvider : throwExceptionDependsOnError() : Session has expired");
                throw new SessionHasExpiredException(errorObject.getString("error_msg"), token.getAccountId());
            }
        }
        catch (JSONException e) {
            logger.error("VkNetworkProvider : throwExceptionDependsOnError() : Cannot parse Vkontakte response");
            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
        }
        logger.error("VkNetworkProvider : throwExceptionDependsOnError() : Vkontakte request returned response in wrong format");
        throw new SocialNetworkException("Vkontakte request returned response in wrong format : " + object.toString(), token.getAccountId());
    }

    @Override
    public Future<UserProfile> fetchUserProfileByUserId(String userId, String socialNetworkAccessToken, final Token token) {
        logger.info("VkNetworkProvider : fetchUserProfileByUserId()");
        WS.WSRequestHolder requestHolder = VkNetworkProvider.usersGetRequest(socialNetworkAccessToken, Lists.newArrayList((Object[])new String[]{userId}));
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<UserProfile>>(){

            public Future<UserProfile> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<UserProfile>(){

                    @Override
                    public UserProfile call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            JSONArray jsonArray = object.getJSONArray("response");
                            ArrayList<UserProfile> userProfiles = new ArrayList<UserProfile>();
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject childJSONObject = jsonArray.getJSONObject(i);
                                UserProfile userProfile = UserProfileHelper.constructUserProfile(childJSONObject.toString(), SocialNetworks.Vkontakte, token);
                                userProfiles.add(userProfile);
                            }
                            if (userProfiles.isEmpty() || userProfiles.size() != 1) {
                                logger.error("VkNetworkProvider : fetchUserProfileByUserId() : error : Cannot parse Vkontakte response");
                                throw new ServiceException("Cannot parse Vkontakte response", token.getAccountId());
                            }
                            return (UserProfile)userProfiles.get(0);
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : fetchUserProfileByUserId() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    @Override
    public Future<Void> shareOnOwnWall(String eventCode, String locale, String socialNetworkAccessToken, String rank, int scores, final Token token) {
        logger.info("VkNetworkProvider : shareOnOwnWall()");
        String message = null;
        MessageCollection messageEnum = MessageCollection.findByEventCode((String)eventCode);
        if (locale.equals(LocaleCollection.en.name())) {
            message = messageEnum.getMessage_en();
        } else if (locale.equals(LocaleCollection.ru.name())) {
            message = messageEnum.getMessage_ru();
        }
        message = String.format(message, Integer.toString(scores), rank);
        String link = messageEnum.getVkUrl();
        WS.WSRequestHolder requestHolder = VkNetworkProvider.postOnTheWallByAccessTokenAndUserIdRequest(null, message, link, socialNetworkAccessToken);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<Void>>(){

            public Future<Void> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            return null;
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : shareOnOwnWall() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    @Override
    public Future<Map<String, Boolean>> checkPermissionsStatusByAccessToken(String socialNetworkAccessToken, final List<String> permissions, final Token token) {
        logger.info("VkNetworkProvider : checkPermissionsStatusByAccessToken()");
        WS.WSRequestHolder requestHolder = VkNetworkProvider.permissionBitMaskByAccessToken(socialNetworkAccessToken);
        return requestHolder.get().getWrappedPromise().flatMap((Function1)new Mapper<WS.Response, Future<Map<String, Boolean>>>(){

            public Future<Map<String, Boolean>> apply(final WS.Response response) {
                return Futures.future((Callable)new Callable<Map<String, Boolean>>(){

                    @Override
                    public Map<String, Boolean> call() throws Exception {
                        int status = response.getStatus();
                        if (status != 200) {
                            throw new ForbiddenException("Vkontakte communication failed." + response.getBody(), token.getAccountId());
                        }
                        try {
                            String bitMask;
                            JSONObject object = new JSONObject(response.getBody());
                            if (object.has("error")) {
                                VkNetworkProvider.this.throwExceptionDependsOnError(object, token);
                            }
                            if ((bitMask = object.getString("response")).equals(SocialNetworkPermissions.VK_REQUIRED_PREMISSION_BIT_MASK.asString())) {
                                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                                for (String eachPermission : permissions) {
                                    map.put(eachPermission, true);
                                }
                                return map;
                            }
                            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                            for (String eachPermission : permissions) {
                                map.put(eachPermission, false);
                            }
                            return map;
                        }
                        catch (JSONException e) {
                            logger.error("VkNetworkProvider : checkPermissionsStatusByAccessToken() : error : Cannot parse Vkontakte response");
                            throw new ServiceException("Cannot parse Vkontakte response", (Throwable)e, token.getAccountId());
                        }
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
    }

    @Override
    public Future<Set<Post>> fetchUserPostsFromOwnWallByAccessToken(String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Future<Set<String>> fetchUserAllUserLikesByAccessToken(String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Set<String> fetchUserAllUserLikesByUserId(String userId, String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Future<Set<Post>> fetchUserPostsFromFriendWallByUserId(String userId, String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Future<Set<UserProfile>> fetchUserSubscribersByAccessToken(String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Future<Set<UserProfile>> fetchUserSubscribersByUserId(String userId, String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Future<Set<UserProfile>> fetchUserFriendsByAccessToken(String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Set<UserProfile> fetchUserFriendsByUserId(String userId, String socialNetworkAccessToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Future<Map<String, String>> extendSocialNetworkAccessToken(String sourceShortLivedToken, Token token) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Set<Post> fetchUserPostsFromFriendWallByUserIdSync(String userId, String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Map<String, Boolean> checkPermissionsStatusByAccessTokenSync(String socialNetworkAccessToken, List<String> permissions, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public UserProfile fetchUserProfileByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public UserProfile fetchUserProfileByUserIdSync(String userId, String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Set<String> fetchUserAllUserLikesByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Set<Post> fetchUserPostsFromOwnWallByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Set<UserProfile> fetchUserSubscribersByUserIdSync(String userId, String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Set<UserProfile> fetchUserSubscribersByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Set<UserProfile> fetchUserFriendsByAccessTokenSync(String socialNetworkAccessToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    @Deprecated
    public Map<String, String> extendSocialNetworkAccessTokenSync(String sourceShortLivedToken, Token token) throws Exception {
        throw new IllegalStateException("Not implemented");
    }

    static {
        BASE_REQUEST = VkConstants.HTTPS_SCHEMA.asString() + "://" + VkConstants.VKONTAKTE_GRAPH_HOST.asString();
    }
}

