/*
 * Decompiled with CFR 0.152.
 */
package helpers.inside;

import constants.SocialNetworks;
import entities.common.UserProfileVO;
import entities.interfaces.UserProfile;
import exceptions.ForbiddenException;
import identity.Token;
import org.json.JSONException;
import org.json.JSONObject;

public class UserProfileHelper {
    public static UserProfile constructUserProfile(String sourceObject, SocialNetworks socialNetwork, Token token) throws JSONException {
        switch (socialNetwork) {
            case Facebook: {
                return UserProfileHelper.createFacebookUserProfileFromFqlJSON(sourceObject, token);
            }
            case Vkontakte: {
                return UserProfileHelper.createVkontakteUserProfileFromJSON(sourceObject, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static UserProfile constructUserSubscriberProfile(String sourceObject, SocialNetworks socialNetwork, Token token) throws JSONException {
        switch (socialNetwork) {
            case Facebook: {
                return UserProfileHelper.createFacebookUserProfileSubscribersFromFqlJSON(sourceObject, token);
            }
        }
        throw new IllegalArgumentException("Illegal social network");
    }

    public static UserProfileVO createVkontakteUserProfileFromJSON(String jsonString, Token token) throws JSONException, ForbiddenException {
        JSONObject counters;
        JSONObject object = new JSONObject(jsonString);
        String id = object.getString("uid");
        String firstName = object.getString("first_name");
        String lastName = object.getString("last_name");
        String name = firstName + " " + lastName;
        String gender = null;
        if (object.has("sex") && !object.getString("sex").equalsIgnoreCase("null")) {
            int sex = object.getInt("sex");
            if (sex == 2) {
                gender = "male";
            } else if (sex == 1) {
                gender = "female";
            }
        }
        String locale = "ru_RU";
        String email = null;
        String pictureUrl = null;
        if (object.has("photo_200_orig") && !object.getString("photo_200_orig").equalsIgnoreCase("null")) {
            pictureUrl = object.getString("photo_200_orig");
        }
        int friendCount = -1;
        if (object.has("counters") && (counters = object.getJSONObject("counters")).has("friends") && !counters.getString("friends").equalsIgnoreCase("null")) {
            friendCount = counters.getInt("friends");
        }
        return new UserProfileVO(id, name, gender, locale, email, pictureUrl, friendCount, SocialNetworks.Vkontakte.name());
    }

    private static UserProfileVO createFacebookUserProfileFromFqlJSON(String jsonString, Token token) throws JSONException, ForbiddenException {
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), token.getAccountId());
        }
        String id = object.getString("uid");
        String name = object.getString("name");
        String gender = null;
        if (object.has("sex") && !object.getString("sex").equalsIgnoreCase("null")) {
            gender = object.getString("sex");
        }
        String locale = null;
        if (object.has("locale") && !object.getString("locale").equalsIgnoreCase("null")) {
            locale = object.getString("locale");
        }
        String email = null;
        if (object.has("email") && !object.getString("email").equalsIgnoreCase("null")) {
            email = object.getString("email");
        }
        String pictureUrl = null;
        if (object.has("pic_big") && !object.getString("pic_big").equalsIgnoreCase("null")) {
            pictureUrl = object.getString("pic_big");
        }
        int friendCount = 0;
        if (object.has("friend_count")) {
            String friendCountString = object.getString("friend_count");
            friendCount = friendCountString != null && !friendCountString.equalsIgnoreCase("null") ? Integer.parseInt(friendCountString) : -1;
        }
        return new UserProfileVO(id, name, gender, locale, email, pictureUrl, friendCount, SocialNetworks.Facebook.name());
    }

    private static UserProfileVO createFacebookUserProfileSubscribersFromFqlJSON(String jsonString, Token token) throws JSONException, ForbiddenException {
        JSONObject dataChildJsonObject;
        JSONObject pictureChildJSONObject;
        JSONObject object = new JSONObject(jsonString);
        if (object.has("error")) {
            throw new ForbiddenException("Facebook communication failed." + object.getString("error"), token.getAccountId());
        }
        String id = object.getString("id");
        String name = object.getString("name");
        String gender = null;
        if (object.has("gender") && !object.getString("gender").equalsIgnoreCase("null")) {
            gender = object.getString("gender");
        }
        String locale = null;
        if (object.has("locale") && !object.getString("locale").equalsIgnoreCase("null")) {
            locale = object.getString("locale");
        }
        String email = null;
        String pictureUrl = null;
        if (object.has("picture") && (pictureChildJSONObject = object.getJSONObject("picture")).has("data") && (dataChildJsonObject = pictureChildJSONObject.getJSONObject("data")).has("url") && !dataChildJsonObject.getString("url").equalsIgnoreCase("null")) {
            pictureUrl = dataChildJsonObject.getString("url");
        }
        int friendCount = 1;
        return new UserProfileVO(id, name, gender, locale, email, pictureUrl, friendCount, SocialNetworks.Facebook.name());
    }
}

