/*
 * Decompiled with CFR 0.152.
 */
package entities.vk;

import entities.common.PostVO;
import entities.common.UserProfileVO;
import entities.interfaces.UserState;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VkUserStateEntity
implements UserState {
    private final String socialNetworkUserId;
    private final String socialNetworkName;
    private final UserProfileVO me;
    private final Set<UserProfileVO> friends;
    private final Set<UserProfileVO> subscribers;
    private final Set<PostVO> posts;
    private final Set<String> allLikedObjectId;

    public VkUserStateEntity(String socialNetworkUserId, String socialNetworkName, UserProfileVO me, Set<UserProfileVO> friends, Set<UserProfileVO> subscribers, Set<PostVO> posts, Set<String> allLikedObjectId) {
        this.socialNetworkUserId = socialNetworkUserId;
        this.socialNetworkName = socialNetworkName;
        this.me = me;
        this.friends = new HashSet<UserProfileVO>();
        if (friends != null && !friends.isEmpty()) {
            this.friends.addAll(friends);
        }
        this.subscribers = new HashSet<UserProfileVO>();
        if (subscribers != null && !subscribers.isEmpty()) {
            this.subscribers.addAll(subscribers);
        }
        this.posts = new HashSet<PostVO>();
        if (posts != null && !posts.isEmpty()) {
            this.posts.addAll(posts);
        }
        this.allLikedObjectId = new HashSet<String>();
        if (allLikedObjectId != null && !allLikedObjectId.isEmpty()) {
            this.allLikedObjectId.addAll(allLikedObjectId);
        }
    }

    @Override
    public String getSocialNetworkUserId() {
        return this.socialNetworkUserId;
    }

    @Override
    public String getSocialNetworkName() {
        return this.socialNetworkName;
    }

    @Override
    public Set<String> getAllLikedObjectId() {
        HashSet<String> result = new HashSet<String>();
        if (this.allLikedObjectId != null && !this.allLikedObjectId.isEmpty()) {
            result.addAll(this.allLikedObjectId);
        }
        return result;
    }

    @Override
    public UserProfileVO getMe() {
        return this.me;
    }

    public Set<UserProfileVO> getFriends() {
        HashSet<UserProfileVO> result = new HashSet<UserProfileVO>();
        if (this.friends != null && !this.friends.isEmpty()) {
            result.addAll(this.friends);
        }
        return result;
    }

    public Set<UserProfileVO> getSubscribers() {
        HashSet<UserProfileVO> result = new HashSet<UserProfileVO>();
        if (this.subscribers != null && !this.subscribers.isEmpty()) {
            result.addAll(this.subscribers);
        }
        return result;
    }

    public Set<PostVO> getPosts() {
        HashSet<PostVO> result = new HashSet<PostVO>();
        if (this.posts != null && !this.posts.isEmpty()) {
            result.addAll(this.posts);
        }
        return result;
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VkUserStateEntity that = (VkUserStateEntity)o;
        if (!this.allLikedObjectId.equals(that.allLikedObjectId)) {
            return false;
        }
        if (!this.friends.equals(that.friends)) {
            return false;
        }
        if (!this.me.equals(that.me)) {
            return false;
        }
        if (!this.posts.equals(that.posts)) {
            return false;
        }
        if (!this.socialNetworkUserId.equals(that.socialNetworkUserId)) {
            return false;
        }
        if (!this.socialNetworkName.equals(that.socialNetworkName)) {
            return false;
        }
        return this.subscribers.equals(that.subscribers);
    }

    public String toString() {
        return "VkUserStateEntity{socialNetworkUserId='" + this.socialNetworkUserId + '\'' + ", socialNetworkName='" + this.socialNetworkName + '\'' + ", me=" + this.me + ", friends=" + this.friends + ", subscribers=" + this.subscribers + ", posts=" + this.posts + ", allLikedObjectId=" + this.allLikedObjectId + '}';
    }
}

