/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.recover;

import audit.Audit;
import dna.play.util.recover.ErrorResponse;
import exceptions.ServiceException;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.PlayException;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;

public final class DefaultExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    private DefaultExceptionHandler() {
    }

    public static Result handle(Throwable t) {
        String message;
        if (t == null) {
            System.err.println("Error: null Message : Unexpected internal error.");
            logger.error("Unexpected internal error.");
            Audit.error((Throwable)new Exception("Unexpected internal error"), (Object)"Unexpected internal error.", null);
            ErrorResponse errorResponse = new ErrorResponse(901, "Service Exception");
            return Results.status((int)500, (JsonNode)Json.toJson((Object)errorResponse));
        }
        if (t instanceof PlayException && t.getCause() != null) {
            t = t.getCause();
        }
        String string = message = t.getMessage() != null ? t.getMessage() : "An error occurred.";
        if (t instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)t;
            int errorCode = serviceException.getDefaultHttpStatusCode();
            String accountId = serviceException.getAccountId();
            ErrorResponse errorResponse = new ErrorResponse(serviceException.getReasonCode(), serviceException.getDescription());
            Audit.error((Throwable)t, (Object)serviceException.getDescription(), (String)accountId);
            logger.error("DefaultExceptionHandler : handle(..) : return result with errorCode : " + errorCode + " and errorResponse json : " + errorResponse.toString() + " accountId : " + accountId);
            return Results.status((int)errorCode, (JsonNode)Json.toJson((Object)errorResponse));
        }
        Audit.error((Throwable)t, (Object)"Service Exception", null);
        logger.error("DefaultExceptionHandler : handle(..) : return result with errorCode : 500 message : Unexpected internal error.");
        ErrorResponse errorResponse = new ErrorResponse(901, "Service Exception");
        return Results.status((int)500, (JsonNode)Json.toJson((Object)errorResponse));
    }
}

