/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.action;

import dna.play.util.RequestHelper;
import dna.play.util.action.Locale;
import exceptions.MissingParameterException;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleAction
extends Action<Locale> {
    private static final String LOCALE_HEADER = "Accept-Language";

    public Result call(Http.Context context) throws Throwable {
        String locale = LocaleAction.parseTokenString(context.request());
        if (locale == null) {
            throw new MissingParameterException("Missing locale", LOCALE_HEADER, null);
        }
        if (!locale.equals("en") && !locale.equals("ru")) {
            locale = "en";
        }
        context.args.put("locale", locale);
        return this.delegate.call(context);
    }

    public static String parseTokenString(Http.Request request) {
        return RequestHelper.parseHeader(LOCALE_HEADER, request);
    }
}

