/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.action;

import dna.play.util.RequestHelper;
import dna.play.util.action.Authorize;
import exceptions.MissingParameterException;
import exceptions.UnauthorizedException;
import identity.Token;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeAction
extends Action<Authorize> {
    private static final String ACCESS_TOKEN_HEADER = "X-Access-Token";

    public Result call(Http.Context context) throws Throwable {
        String tokenString = AuthorizeAction.parseTokenString(context.request());
        Token token = AuthorizeAction.authorize(tokenString);
        context.args.put("token", token);
        return this.delegate.call(context);
    }

    public static String parseTokenString(Http.Request request) {
        Object accessToken = null;
        return RequestHelper.parseHeader(ACCESS_TOKEN_HEADER, request);
    }

    public static Token authorize(String accessToken) {
        if (accessToken == null) {
            throw new MissingParameterException("Missing access token", "accessToken", null);
        }
        Token token = Token.decode((String)accessToken);
        if (token.isExpired()) {
            throw new UnauthorizedException("Token has been expired.", null);
        }
        return token;
    }
}

