/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.jmonitor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import jmonitor.JMonitorFactory;
import org.codehaus.jackson.JsonNode;
import play.libs.Json;

public class JMonitorUtil {
    static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String HTML_START = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n<meta charset=\"utf-8\">\n<title>Jamon admin</title>\n<link href=\"https://ajax.aspnetcdn.com/ajax/jquery.dataTables/1.9.0/css/jquery.dataTables.css\" rel=\"stylesheet\">\n</head>\n<body>\n<h1>Jamon admin</h1>\n<a href=\"?reset=true\">Reset counters</a><br/>\n<table border=\"1\" rules=\"all\">\n";
    private static final String HTML_END = "</table>\n<script src=\"https://ajax.aspnetcdn.com/ajax/jQuery/jquery-1.7.2.min.js\"></script>\n<script src=\"https://ajax.aspnetcdn.com/ajax/jquery.dataTables/1.9.0/jquery.dataTables.min.js\"></script>\n<script>$(function() {$(\"table\").dataTable({ 'aLengthMenu' : [[25, 50, 100, 200], [25, 50, 100, 200]], 'iDisplayLength' : 25 });});</script>\n</body>\n</html>";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");

    public static String instance(boolean reset) {
        if (reset) {
            JMonitorFactory.reset();
        }
        List data = JMonitorFactory.data();
        return gson.toJson((Object)data).toString();
    }

    private static String formatTimestamp(Object oTimestamp) {
        Long timestamp = null;
        try {
            timestamp = ((Number)oTimestamp).longValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (timestamp == null) {
            return null;
        }
        if (timestamp == 0L) {
            return "-";
        }
        return sdf.format(new Date(timestamp));
    }

    private static String asHtml(JsonNode json) {
        List list = (List)Json.fromJson((JsonNode)json, List.class);
        StringBuilder htmlPageBuilder = new StringBuilder();
        htmlPageBuilder.append(HTML_START);
        boolean printHead = true;
        if (list != null && list.size() > 0) {
            for (LinkedHashMap map : list) {
                map.put("firstaccess", JMonitorUtil.formatTimestamp(map.get("firstaccess")));
                map.put("lastaccess", JMonitorUtil.formatTimestamp(map.get("lastaccess")));
                if (printHead) {
                    htmlPageBuilder.append("<thead>\n<tr>");
                    for (String key : map.keySet()) {
                        htmlPageBuilder.append("<th>" + key + "</th>");
                    }
                    htmlPageBuilder.append("</tr>\n</thead>\n<tbody>\n");
                    printHead = false;
                }
                htmlPageBuilder.append("<tr>");
                for (Object value : map.values()) {
                    htmlPageBuilder.append("<td>" + (value == null ? "?" : value.toString()) + "</td>");
                }
                htmlPageBuilder.append("</tr>\n");
            }
            htmlPageBuilder.append("</tbody>\n");
        }
        htmlPageBuilder.append(HTML_END);
        return htmlPageBuilder.toString();
    }

    public static String instanceAsHtml(boolean reset) {
        return JMonitorUtil.asHtml(Json.parse((String)JMonitorUtil.instance(reset)));
    }
}

