/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.action;

import dna.play.util.action.IpLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Play;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpLimitAction
extends Action<IpLimit> {
    private static final Logger logger = LoggerFactory.getLogger(IpLimitAction.class);
    private boolean disableIpLimit = false;

    public IpLimitAction() {
        Boolean value = Play.application().configuration().getBoolean("dna.play.util.ignoreIpLimit");
        if (value != null) {
            this.disableIpLimit = value;
        }
        if (this.disableIpLimit) {
            logger.warn("dna.play.util.ignoreIpLimit = true: ip limit errors are going to be ignored");
        }
    }

    public IpLimitAction(boolean enabled) {
        this.disableIpLimit = !enabled;
    }

    public Result call(Http.Context context) throws Throwable {
        String ip = this.getRemoteAddress(context);
        if (this.validateIp(ip) || this.disableIpLimit) {
            return this.delegate.call(context);
        }
        return IpLimitAction.forbidden((String)("Access denied from ip " + ip + "."));
    }

    private String getRemoteAddress(Http.Context context) {
        String clientIp = context.request().remoteAddress();
        if (clientIp == null || "0:0:0:0:0:0:0:1".equals(clientIp)) {
            return "127.0.0.1";
        }
        return clientIp;
    }

    private boolean validateIp(String ip) {
        String[] addressList;
        if (((IpLimit)this.configuration).addresses().contains(ip)) {
            return true;
        }
        for (String address : addressList = ((IpLimit)this.configuration).addresses().split(",")) {
            if (!this.checkIpPattern(address, ip)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIpPattern(String pattern, String ip) {
        String[] patternParts = pattern.split("\\.");
        String[] ipParts = ip.split("\\.");
        for (int i = 0; i < patternParts.length; ++i) {
            if (patternParts[i].equals("*") || patternParts[i].equals(ipParts[i])) continue;
            return false;
        }
        return true;
    }
}

