/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.controller;

import dna.play.util.jmonitor.JMonitorUtil;
import exceptions.MissingParameterException;
import identity.Token;
import java.util.Map;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseController
extends Controller {
    public static final String TOKEN = "token";
    public static final String REQUEST_BODY = "requestBody";

    public static String getRequiredParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            if (params[0].isEmpty()) {
                throw new MissingParameterException("Missing parameter", paramName, null);
            }
            return params[0];
        }
        throw new MissingParameterException("Missing parameter", paramName, null);
    }

    public static String getParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            if (params[0].isEmpty()) {
                return null;
            }
            return params[0];
        }
        return null;
    }

    public static Token getToken() {
        Token token = null;
        if (BaseController.ctx().args.containsKey(TOKEN)) {
            token = (Token)BaseController.ctx().args.get(TOKEN);
        }
        return token;
    }

    private static Map<String, String[]> getRequestParameters(Http.Request request) {
        Map params = BaseController.getRequestBody();
        if (params == null || params.isEmpty()) {
            params = request.body().asFormUrlEncoded();
            BaseController.storeRequestBody(params);
            if (params == null) {
                throw new MissingParameterException("Missing request content type", "contentType", null);
            }
        }
        return params;
    }

    private static Map<String, String[]> getRequestBody() {
        Map reqBody = null;
        if (BaseController.ctx().args.containsKey(REQUEST_BODY)) {
            reqBody = (Map)BaseController.ctx().args.get(REQUEST_BODY);
        }
        return reqBody;
    }

    private static void storeRequestBody(Map<String, String[]> reqBody) {
        Http.Context context = BaseController.ctx();
        context.args.put(REQUEST_BODY, reqBody);
    }

    public static Result jMonitorInstance(boolean reset) {
        return BaseController.ok((String)JMonitorUtil.instanceAsHtml(reset)).as("text/html");
    }
}

