/*
 * Decompiled with CFR 0.152.
 */
package dna.play.util.settings;

import dna.play.util.jmonitor.JMonitor;
import dna.play.util.jmonitor.JMonitorFactory;
import dna.play.util.recover.DefaultExceptionHandler;
import java.lang.reflect.Method;
import play.GlobalSettings;
import play.Logger;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

public class BaseGlobal
extends GlobalSettings {
    public Result onError(Http.RequestHeader requestHeader, Throwable throwable) {
        Logger.debug((String)"BaseGlobal : onError(..)");
        return DefaultExceptionHandler.handle(throwable);
    }

    public Action onRequest(Http.Request request, Method actionMethod) {
        final Action target = super.onRequest(request, actionMethod);
        if (JMonitorFactory.isEnabled()) {
            final String label = "Api: " + actionMethod.getDeclaringClass().getSimpleName() + "." + actionMethod.getName();
            Action.Simple wrapper = new Action.Simple(){

                public Result call(Http.Context ctx) throws Throwable {
                    final JMonitor monitor = JMonitorFactory.start(label);
                    final JMonitor allMonitor = JMonitorFactory.start("Api: all");
                    target.delegate = this.delegate;
                    Result result = target.call(ctx);
                    if (result instanceof Results.AsyncResult) {
                        Results.AsyncResult asyncResult = (Results.AsyncResult)result;
                        return asyncResult.transform((F.Function)new F.Function<Result, Result>(){

                            public Result apply(Result a) throws Throwable {
                                monitor.stop();
                                allMonitor.stop();
                                return a;
                            }
                        });
                    }
                    monitor.stop();
                    allMonitor.stop();
                    return result;
                }
            };
            return wrapper;
        }
        return target;
    }
}

